<?php namespace Intellex\Upload;

/**
 * Class Encoder
 *
 * @package Intellex\Upload
 */
class Coder {

	/** @var array The problematic characters. */
	private static $FROM = [ '+', '/', '=' ];

	/** @var array The safe characters. */
	private static $TO = [ '-', '_', '.' ];

	/**
	 * Encode a binary to a safe string.
	 *
	 * @param mixed $binary The binary to encode.
	 *
	 * @return string The data which is safe for most systems and applications
	 */
	public static function encode($binary) {
		return urlencode(str_replace(static::$FROM, static::$TO, base64_encode($binary)));
	}

	/**
	 * Decode a safe string to a binary.
	 *
	 * @param string $input The string to decode.
	 *
	 * @return mixed The original binary.
	 */
	public static function decode($input) {
		return base64_decode(str_replace(static::$TO, static::$FROM, urldecode($input)));
	}

}