<?php namespace Intellex\Pixabay\Data;

class Page extends DataAbstract {

	/** @var string The total number of hits. */
	public $total;

	/** @var string The number of images accessible through the API. By default, the API is limited to return a maximum of 500 images per query. */
	public $totalHits;

	/** @var The array of all hits. */
	public $hits;

	/** @var array The validation rules. */
	protected function validationRules() {
		return [
			'total'		=> 'nonNegativeInteger',
			'totalHits' => 'nonNegativeInteger',
			'hits'		=> 'array'
		];
	}

	/**
	 * Initialize the Page from JSON object.
	 *
	 * @param JSON The json to read the data from.
	 * @param string $type The name of the class form hits.
	 */
	public function __construct($json, $type) {
		$this->total = $json->total;
		$this->totalHits = $json->totalHits;

		# Set hits
		$className = '\\Intellex\\Pixabay\\Data\\' . $type;
		foreach($json->hits as $hit) {
			$this->hits[] = new $className($hit);
		}

		$this->validate();
	}

}
