<?php namespace Intellex\Manicure\Source;

use Intellex\Manicure\Dimension;

/**
 * A source which is a pure image data.
 */
class ImageDataSource implements SourceInterface {

	/** @var mixed The image data itself. */
	private $data;

	/** @var Dimension The dimension of the image. */
	private $dimension;

	/**
	 * ImageDataSource constructor.
	 *
	 * @param mixed $data The image data itself.
	 */
	public function __construct($data) {
		$this->data = $data;
		$this->dimension = new Dimension(-1, -1);
	}

	/** @inheritdoc */
	function getData() {
		return $this->data;
	}

	/** @inheritdoc */
	function getWidth() {

		// Use cache
		if ($this->dimension->width === -1) {
			$this->dimension->width = imagesx($this->data);
		}

		return $this->dimension->width;
	}

	/** @inheritdoc */
	function getHeight() {

		// Use cache
		if ($this->dimension->height === -1) {
			$this->dimension->height = imagesy($this->data);
		}

		return $this->dimension->height;
	}

}