<?php namespace Intellex\Manicure\Plugin;

use Intellex\Manicure\Source\ImageDataSource;
use Intellex\Manicure\Source\SourceInterface;

class Flip implements PluginInterface {

	private $mode;

	public function __construct($mode = IMG_FLIP_HORIZONTAL) {
		$this->mode = $mode;
	}

	/**
	 * @param SourceInterface $source                           The source on which to apply the
	 *                                                          manipulation.
	 *
	 * @return SourceInterface The reworked source.
	 */
	public function apply(SourceInterface $source) {
		$data = $source->getData();
		imageflip($data, $this->mode);
		return new ImageDataSource($data);
	}
}
