<?php namespace Intellex\MailChimp\Resource;

class ResourceReport {

	/** @var string Unique ID of the member. */
	public $id;

	/** @var array The complete data from the API. */
	public $data;

	/**
	 * ListResource constructor.
	 *
	 * @param object $data The data to convert to List.
	 */
	function __construct($data) {
		$this->id = $data['id'];
		$this->data = $data;
	}

	/** @return string Unique ID of the member. */
	public function getId() {
		return $this->id;
	}

	/**
	 * Get the total number of rejected deliveries.
	 *
	 * @return int The total bounces.
	 */
	public function getTotalBounces() {
		return array_sum($this->data['bounces']);
	}

	/**
	 * @return int The number of unique opens.
	 */
	public function getUniqueOpens() {
		return $this->data['opens']['unique_opens'];
	}

	/**
	 * @return int The percent, open rate.
	 */
	public function getOpenRate() {
		return round($this->data['opens']['open_rate'] * 100, 2);
	}

	/**
	 * @return int The number of unique opens.
	 */
	public function getUniqueClicks() {
		return $this->data['clicks']['unique_clicks'];
	}

	/**
	 * @return int The percent, open rate.
	 */
	public function getClickRate() {
		return round($this->data['clicks']['click_rate'] * 100, 2);
	}

}