<?php namespace Intellex\MailChimp\Resource;

class ResourceList {

	/** @var string Unique ID of the list. */
	public $id;

	/** @var string The name of the list. */
	public $name;

	/** @var string The name of the list. */
	public $contact;

	/** @var string Contact information displayed in campaign footers to comply with international spam laws. */
	public $permission_reminder;

	/** @return string Default values for campaigns created for this list. */
	public $campaign_defaults;

	/**
	 * ListResource constructor.
	 *
	 * @param object $data The data to convert to List.
	 */
	function __construct($data) {
		$this->id = $data['id'];
		$this->name = $data['name'];
		$this->contact = [
			'company' => $data['contact']['company'],
			'address1' => $data['contact']['address1'],
			'city' => $data['contact']['city'],
			'state' => $data['contact']['state'],
			'zip' => $data['contact']['zip'],
			'country' => $data['contact']['country'],
			'phone' => $data['contact']['phone'],
		];
		$this->permission_reminder = $data['permission_reminder'];
		$this->campaign_defaults = [
			'from_name' => $data['campaign_defaults']['from_name'],
			'from_email' => $data['campaign_defaults']['from_email'],
			'subject' => $data['campaign_defaults']['subject'],
			'language' => $data['campaign_defaults']['language'],
		];
	}

	/** @return string Unique ID of the list. */
	public function getId() {
		return $this->id;
	}

	/** @return string The name of the list. */
	public function getName() {
		return $this->name;
	}

	/** @return string The Contact information ofr the list. */
	public function getContacat() {
		return $this->contact;
	}

	/** @var string Contact information displayed in campaign footers to comply with international spam laws. */
	public function getPermissionReminder() {
		return $this->permission_reminder;
	}

	/** @return string Default values for campaigns created for this list. */
	public function getCampaignDefaults() {
		return $this->campaign_defaults;
	}

}