<?php namespace Intellex\MailChimp\Enum;

/**
 * Class SubscriberStatus
 * A list of all available statuses for the member subscription option.
 *
 * @package Intellex\MailChimp\Enum
 */
class SubscriberStatus {

	/** @const string The active subscriber on the list. */
	const SUBSCRIBED = 'subscribed';

	/** @const string The inactive subscriber on the list, which has revoked the subscription. */
	const UNSUBSCRIBED = 'unsubscribed';

	/** @const string Removed from the list. */
	const CLEANED = 'cleaned';

	/** @const string Requires an additional approval my email owner in order to become SUBSCRIBED. */
	const PENDING = 'pending';

}