<?php namespace Intellex\MailChimp;

/**
 * Class Config
 * The configuration for the Mail Chimp client.
 *
 * @package Intellex\MailChimp
 */
class Config {

	/** @const string The version of the Mail Chimp API to use. */
	const VERSION = '3.0';

	/** @var string The secret API key for the Mail Chimp client. */
	private $apiKey;

	/**
	 * Config constructor.
	 *
	 * @param string $apiKey The secret API key for the Mail Chimp client.
	 */
	public function __construct($apiKey) {
		$this->apiKey = $apiKey;
	}

	/** @return string The secret API key for the Mail Chimp client. */
	public function getApiKey() {
		return $this->apiKey;
	}

	/** @return string The code of the Mail Chimp data center to target, based on the API key. */
	public function getApiKeyDataCenter() {
		return substr($this->apiKey, strpos($this->apiKey, '-') + 1);
	}

	/** @return string The base URL for all request, including trailing slash. */
	public function getBaseURL() {
		return 'https://' . $this->getApiKeyDataCenter() . '.api.mailchimp.com/' . static::VERSION . '/';
	}

}