<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 23.10.17.
 * Time: 17.25
 */

namespace Intellex\Generator\Text;

/**
 * Generate a single sentence.
 * Class SentenceGenerator
 *
 * @package Intellex\AutoPopulate\Generator
 */
class SentenceGenerator extends WordGenerator {

	/** @var int $min Minimum number of words. */
	private $min;

	/**@var int $max Maximum number of words. */
	private $max;

	/** @var bool $dot Sets dots at end of the sentence. */
	private $dot;

	/** @var bool $comma Sets commas on random places in sentence. */
	private $comma;

	/**
	 * Constructor for SentenceGenerator.
	 * SentenceGenerator constructor.
	 *
	 * @param null $words
	 * @param int  $min
	 * @param int  $max
	 * @param bool $dot
	 * @param bool $comma
	 */
	public function __construct($min = 5, $max = 25, $dot = true, $comma = true, $words = null) {
		parent::__construct($words);
		$this->dot = $dot;
		$this->comma = $comma;
		$this->min = $min;
		$this->max = $max;

	}

	/**
	 * Generate a random sentence.
	 *
	 * @return string.
	 */
	public function generateValue() {
		return $this->generateSentence();
	}

	/**
	 * @return string
	 */
	public function generateSentence(){
		$len = rand($this->min, $this->max);

		// Used to make sure we have only one comma per sentence.
		$hasComma = false;

		$sentence = '';
		for ($i = 0; $i < $len; $i++) {

			// Separate word
			$glue = '';
			if (strlen($sentence)) {

				// Optional comma
				$glue = ' ';
				if ($this->comma && !$hasComma && rand(6, 11) == $i) {
					$hasComma = true;
					$glue = ', ';
				}
			}

			// Get word
			$word = parent::generateValue();

			$sentence .= $glue . $word;
		}

		return ucfirst($sentence) . ($this->dot ? '.' : null);
	}
}