<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 24.10.17.
 * Time: 13.01
 */

namespace Intellex\Generator\Text\HTML;

class HTMLArticleGenerator extends HTMLh2Section {

	/** @var bool $h1 Determines whether the article should have a <h1> title tag. Default = true */
	private $h1;

	/** @var int $min Minimum number of h2 sections given to article. */
	private $min;

	/** @var int $max Maximum number of h2 sections given to article. */
	private $max;

	/** @var int $numOfParAfterH1 Number of paragraphs after <h1> title. */
	private $numOfParAfterH1;

	/** @var string $imgAPI API Key for pixabay. */
	private $imgAPI;

	/**
	 * HTMLArticleGenerator constructor.
	 *
	 * @param string $imgAPI                  API Key for pixabay.
	 * @param bool   $h1                      Determines whether the article should have a <h1>
	 *                                        title tag. Default = true
	 * @param int    $numOfParAfterH1         Number of paragraphs after <h1> title.
	 * @param int    $min                     Minimum number of h2 sections given to article.
	 * @param int    $max                     Maximum number of h2 sections given to article.
	 */
	public function __construct($imgAPI = null, $h1 = true, $numOfParAfterH1 = 1, $min = 2, $max = 4) {
		parent::__construct();
		$this->min = $min;
		$this->max = $max;
		$this->numOfParAfterH1 = $numOfParAfterH1;
		$this->h1 = $h1;
		$this->imgAPI = $imgAPI;

	}

	/**
	 * Generates a complete article.
	 *
	 * @return string
	 */
	public function generateValue() {
		return $this->generateArticle($this->imgAPI);
	}

	/**
	 *  Generates an Article.
	 *
	 * @param string $imgAPI API Key for pixabay.
	 *
	 * @return string
	 */
	public function generateArticle($imgAPI = null) {
		if ($this->imgAPI !== null) {
			$imgAPI = $this->imgAPI;
		}

		return $this->h1 ? implode("\n\n", [
			parent::tag('h1', parent::generateSentence(5, 7, null, false, null)),
			parent::generateParagraphs($imgAPI, $this->numOfParAfterH1, $this->numOfParAfterH1),
			parent::generateH2Sections($imgAPI, $this->min, $this->max)
		]) : implode("\n\n", [
			parent::generateParagraphs($imgAPI, $this->numOfParAfterH1, $this->numOfParAfterH1),
			parent::generateH2Sections($imgAPI, $this->min, $this->max)
		]);

	}

}