<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 23.10.17.
 * Time: 14.16
 */

//namespace Intellex\AutoPopulate\Generator;
namespace Intellex\Generator\Basic;

use Intellex\Generator\Core\ItemGenerator;
class RandomStringGenerator extends ItemGenerator {

	/** @var int $min Minimum length for random string. */
	private $min;

	/** @var int $max Maximum length for random string. */
	private $max;

	private $prefix;

	private $sufix;

	/**
	 * RandomStringGenerator constructor.
	 *
	 * @param int    $min        Minimum length for random string.
	 * @param int    $max        Maximum length for random string.
	 * @param string $characters Characters that we want to use for generating random string.
	 */
	public function __construct($min, $max, $characters, $prefix = '', $sufix = '') {
		$this->min = $min;
		$this->max = $max;
		$array = str_split($characters);
		$this->prefix = $prefix;
		$this->sufix = $sufix;
		parent::__construct($array);
	}

	/**
	 * Generate a value for a column.
	 *
	 * @return mixed The generated value.
	 */
	public function generateValue() {
		$randString = '';
		$length = rand($this->min, $this->max);
		while ($length--) {
			$randString .= parent::generateValue();
		}
		return $this->prefix . $randString . $this->sufix;

	}
}