<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 16.10.17.
 * Time: 18.12
 */

//namespace Intellex\AutoPopulate\Generator;
namespace Intellex\Generator\Basic;

use Intellex\Generator\Core\GeneratorInterface;
/**
 * Generates a GPS location, within a supplied radius.
 *
 * @package Intellex\AutoPopulate\Generator
 */
class GpsLocationGenerator implements GeneratorInterface {

	/** @const int How much meters per degree longitude. */
	const METERS_PER_LATITUDE = 111000;

	/** @var float $latitude Specifies the geographic latitude for a specific point.*/
	private $latitude;

	/** @var float float $longitude Specifies the geographic longitude for a specific point */
	private $longitude;

	/** @var int $distance Radius range for random GPS location in depends of given coordinates. */
	private $distance;

	/**
	 * GpsLocationGenerator constructor.
	 *
	 * @param float $latitude  Latitude of the center or the circle.
	 * @param float $longitude Latitude of the center  or the circle.
	 * @param int   $distance  Radius of the circle, in meters.
	 */
	public function __construct($latitude = 52.3677607, $longitude = 4.8785829, $distance = 1000) {
		$this->latitude = $latitude;
		$this->longitude = $longitude;
		$this->distance = $distance;
	}

	/**
	 * Generate a GPS location.
	 *
	 * @return string GPS location in format: '<decimal>, <decimal>'.
	 */
	public function generateValue() {
		$m = rand(0, 1000) / 1000;
		$rand = rand(0, 1000) / 1000;
		$angle = 2 * M_PI * $rand;
		$a = $this->latitude + $this->distance / static::METERS_PER_LATITUDE * $m * cos($angle);
		$b = $this->longitude + $this->distance / static::METERS_PER_LATITUDE * $m * sin($angle);
		$a = number_format($a, 6, '.', ',');
		$b = number_format($b, 6, '.', ',');
		return $a . ',' . $b;
	}

}