<?php
/**
 * Created by PhpStorm.
 * User: sale
 * Date: 19.10.17.
 * Time: 14.28
 */

//namespace Intellex\AutoPopulate\Generator;
namespace Intellex\Generator\Basic;

use Intellex\Generator\Core\GaussianDistributionGenerator;
class DateTimeGenerator extends GaussianDistributionGenerator {

	/** @var boolean Set to true to use normal distribution around middle time. */
	private $gauss;

	/**
	 * TimeGenerator constructor.
	 *
	 * @param int  $from Starting range for random date.
	 * @param int  $to Ending range for random date.
	 * @param bool $gauss Set to true to use normal distribution around middle time.
	 */
	public function __construct($from = '-1 month', $to = '+1 month', $gauss = false) {
		$from = strtotime($from);
		$to = strtotime($to);
		$diff = ($to - $from) / 2;
		$mean = $from + $diff;
		$deviation = $diff / 5;
		parent::__construct($mean, $deviation, $from, $to);
	}

	/**
	 * Generate a value for a column.
	 *
	 * @return mixed The generated value.
	 */
	public function generateValue() {
		if($this->gauss) {
			$date = parent::generateValue();
		} else {
			$date = rand($this->min, $this->max);
		}

		return date('Y-m-d H:i:s', $date);
	}
}