<?php

use Intellex\Filesystem\File;

require_once __DIR__ . DIRECTORY_SEPARATOR . 'bootstrap.php';

// Build filesystem
define('ROOT', __DIR__ . DIRECTORY_SEPARATOR . 'filesystem' . DIRECTORY_SEPARATOR);
require 'buildfilesystem.php';

// Write
$file = new File(ROOT . 'index.php');
$file->write('<h1>Hello :)</h1>');

// Read
$file = new File(ROOT . 'index.php');
test($file->read() === '<h1>Hello :)</h1>', "File read failed!");

// Delete
$file->delete();
test(!$file->exists(), "File delete failed!");

// Create file
$file = new File(ROOT . 'file to move');
$file->write("here I am1");
test($file->exists(), "File creation failed!");

// File copy
$destination = ROOT . 'img' . DIRECTORY_SEPARATOR . 'copy_of';
$file->copyTo($destination);
test($file->exists(), "File copy failed!");
test($file->getPath() === $destination, "Copied file filename missmatch!");

// File move
$destination = ROOT . 'moved';
$file->moveTo($destination);
test($file->exists(), "File move failed!");
test($file->getPath() === $destination, "Moved file filename missmatch!");

// Test the MIME extension validator
$file = new File(ROOT . 'business-audit.svg');
test($file->getExtension() === 'svg', "Extension check failed!");
test($file->getExtension(true) === 'svg', "MIME extension check failed!");

echo "PASSED!" . PHP_EOL . PHP_EOL;
debug(glob(ROOT . '*'));

function test($test, $message) {
	if (!$test) {
		throw new Exception($message);
	}
}