<?php namespace Intellex\Filesystem\Exception;

/**
 * Class PathNotFoundException
 * A path should be a directory, file found.
 *
 * @package Intellex\Filesystem\Exception
 */
class NotADirectoryException extends FilesystemException {

	public function __construct($path) {
		$path = static::getPath($path);
		parent::__construct("The supplied path `{$path}` is not a directory.");
	}

}
