<?php namespace Intellex\Filesystem\Exception;

use Intellex\Filesystem\Path;

/**
 * Class PathNotFoundException
 * A path should be a file, directory found.
 *
 * @package Intellex\Filesystem\Exception
 */
abstract class FilesystemException extends \Exception {

	/**
	 * Get the string path.
	 *
	 * @param Path|string $object Either object of Path or a string to the path.
	 *
	 * @return string The requested path.
	 */
	public static function getPath($object) {
		return $object instanceof Path
			? $object->getPath()
			: $object;
	}
}
