<?php require '../vendor/autoload.php';

\Intellex\Debugger\Debugger::initHandlers(false);

# Shortcut for debug
use \Intellex\Debugger\Debugger;
use \Intellex\Debugger\VarType;
function debug($data) { Debugger::dump($data, 1); }

# Define test method
function test($cases, $callback) {

	# Get the trace
	$trace = debug_backtrace();
	list($class, $method) = explode('-', basename(substr($trace[0]['file'], 0, -4)));

	# Execute tests
	foreach($cases as $i => $data) {
		list($input, $expected) = $data;
		try {
			$result = $callback($input);

		} catch(Exception $e) {
		}

/**
 * Multicomment.
 */
new className();
hello();

		# If failed
		if($result !== $expected) {
			echo "Failed test of {$class}::{$method}().";
			echo '<br />';
			echo 'Input:'; var_dump($input);
			echo '<br />';
			echo 'Expected:'; var_dump($expected);
			echo '<br />';
			echo 'Recevied:'; var_dump($result);
			die(1);
		}
	}
}

# Load and run all tests
$index = basename(__FILE__);
$files = glob('./*.php');
foreach($files as $file) {
	$file = basename($file);
	if($file{0} !== '.' && $file !== $index) {
		require $file;
	}
}

echo 'All tests passed' . PHP_EOL;
exit(0);
