<?php

/**
 * @var \Exception $exception The exception to render.
 * @var array      $history   The complete trace history.
 */

// Style
$wide = 140;
$chars = [
	[ "╒", "═", "╕" ],
	[ "│", " ", "│" ],
	[ "╘", "═", "╛" ]
];

// Set the template
$template = $chars[0][0] . str_repeat($chars[0][1], $wide - 2) . $chars[0][2] . "\n";
$template .= $chars[1][0] . str_repeat(' ', $wide - 2) . $chars[1][2] . "\n";
$template .= "%s\n";
$template .= $chars[1][0] . str_repeat(' ', $wide - 2) . $chars[1][2] . "\n";
$template .= $chars[2][0] . str_repeat($chars[2][1], $wide - 2) . $chars[2][2] . "\n";

// Create message
$lines = [ $exception->getMessage(), null ];
foreach ($history as $i => $step)
	if ($i) {

		if (key_exists('file', $step)) {
			$lines[] = $step['file'] . ' : ' . $step['line'];
		}

		foreach ($step['snippet'] as $i => $line) {
			$sign = '   ';
			if ($i === $step['line']) {
				$sign = '-->';
				$lines[] = null;
			}

			$lines[] = " {$sign} {$i} {$line}";

			if ($i === $step['line']) {
				$lines[] = null;
			}
		}
		$lines[] = null;
	}

// Lines
foreach ($lines as $i => $val) {
	$lines[$i] = $chars[1][0] . ' ' . $lines[$i];
	$lines[$i] .= str_repeat(' ', max(1, $wide + 1 - strlen($lines[$i])));
	$lines[$i] .= $chars[1][2];
}

// Print plain text
printf($template, implode("\n", $lines));


