<?php namespace Intellex\Debugger;
class VarType {

	/** A null value. */
	const NULL_ = "null";

	/** A boolean type. */
	const BOOLEAN_ = "boolean";

	/** An integer type. */
	const INTEGER_ = "integer";

	/** A float or double type. */
	const FLOAT_ = "float";

	/** A string type. */
	const STRING_ = "string";

	/** An array type. */
	const ARRAY_ = "array";

	/** An object type. */
	const OBJECT_ = "object";

	/** An resource type. */
	const RESOURCE_ = "resource";

	/**
	 * Get the variable type of the supplied variable.
	 *
	 * @param	mixed	The variable to check the type.
	 *
	 * @return	string	The type of the supplied variable.
	 */
	public static function of($var) {
		switch(true) {
			case is_null($var):		return static::NULL_;
			case is_resource($var):	return static::RESOURCE_;
			case is_bool($var):		return static::BOOLEAN_;
			case is_float($var):
			case is_double($var):	return static::FLOAT_;
			case is_integer($var):	return static::INTEGER_;
			case is_string($var):	return static::STRING_;
			case is_array($var):	return static::ARRAY_;
			case is_object($var):	return static::OBJECT_;
		}
	}

}
