<?php require '../vendor/autoload.php';

use Intellex\Curly\URL;

$cases = [
	[ URL::create('http', 'google.com', '', [ ]),
		'http://google.com' ],

	[ URL::create('http', 'google.com', '', [ ]),
		'http://google.com' ],

	[ URL::create('http', 'google.com', '', [ ]),
		'http://google.com' ],

	[ URL::create(' HttPs ', 'google.com', 'hello', [ ]),
		'https://google.com/hello' ],

	[ URL::create('hTTps', 'google.com', 'hello/there', [ ]),
		'https://google.com/hello/there' ],

	[ URL::create('HTTPS', 'google.com', 'hello/there', [ 'get' => 'true' ]),
		'https://google.com/hello/there?get=true' ],

	[ URL::create('httpS', 'google.com', 'hello/there', [ 'user' => [ 'name' => 'Ivan', 'surname' => 'Sabo', 'company' => [ 'name' => 'Intellex', 'location' => [ 'country' => 'Serbia', 'city' => 'Belgrade' ] ] ], 'tags' => [ 'one', '1', 'apple', 'bannana' ] ]),
		'https://google.com/hello/there?user[name]=Ivan&user[surname]=Sabo&user[company][name]=Intellex&user[company][location][country]=Serbia&user[company][location][city]=Belgrade&tags[0]=one&tags[1]=1&tags[2]=apple&tags[3]=bannana' ],

	[ URL::create('https', 'www.intellex.rs', 'about-us', [ ]),
		'https://www.intellex.rs/about-us' ],

	[ URL::create('Http', 'intellex.rs', '404-error-page', [ ]),
		'http://intellex.rs/404-error-page' ],
];

test(
	$cases,
	function($input, $expected) {
		return $input->toString();
	}
);

