<?php require '../vendor/autoload.php';

use Intellex\Curly\Protocol;
use Intellex\Curly\Exception\ProtocolNotSupportedException;

$cases = [
	[ 'HTTP', Protocol::HTTP ],
	[ 'HTTPS', Protocol::HTTPS ],
	[ 'http ', Protocol::HTTP ],
	[ 'https', Protocol::HTTPS ],
	[ 'Http', Protocol::HTTP ],
	[ 'httpS', Protocol::HTTPS ],
	[ ' http ', Protocol::HTTP ],
	[ null, new ProtocolNotSupportedException(null) ],
	[ '', new ProtocolNotSupportedException('') ],
	[ 'ftp', new ProtocolNotSupportedException('ftp') ],
	[ 'ssh', new ProtocolNotSupportedException('ssh') ]
];

test($cases, function($input) { return \Intellex\Curly\Protocol::validate($input); });
