<?php namespace Intellex\Curly\Exception;

/**
 * Indicates that the requested URL cannot be properly parsed.
 */
class UnparseableURLException extends \Exception {

	/**
	 * Initialize the exception.
	 *
	 * @param    string $url The url that was not recognized.
	 */
	public function __construct($url) {
		parent::__construct("Supplied URL `{$url}` cannot be parsed.");
	}

}
