<?php namespace Intellex\Curly\Exception;

/**
 * Indicates that the requested protocol does not exist or it is not yet supported.
 */
class ProtocolNotSupportedException extends \Exception {

	/**
	 * Initialize the exception.
	 *
	 * @param	string	$protocol	The protocol that was not recognized.
	 */
	public function __construct($protocol) {
		parent::__construct("Supplied protocol `{$protocol}` is not supported.");
	}

}
