<?php namespace Intellex\Curly\Content\TypeHandlers;

use Intellex\Curly\Content\TypeHandlerInterface;

/**
 * Parses the URL encoded form data.
 */
class URLEncoded implements TypeHandlerInterface {

	/**
	 * Extract the values;
	 *
	 * @param string $raw The raw content.
	 *
	 * @return string The extracted data.
	 */
	public function parse($raw) {
		parse_str($raw, $parsed);
		return $parsed;
	}

	/**
	 * Format the data based on the type.
	 *
	 * @param mixed $data The data to format.
	 *
	 * @return string The formatted data.
	 */
	function format($data) {

		// Handle empty data;
		if (empty($data)) {
			return '';
		}

		return http_build_query($data);
	}

}
