<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>EuroAudit</title>

	<link rel="stylesheet" href="/css/1-main.css" type="text/css" />
	<link rel="stylesheet" href="/css/2-slick.css" type="text/css" />

</head>

<body>

	<?php include('img/icons/ea-icons.svg'); ?>

    <?php include('inc/header.php'); ?>

	<div class="hero page-hero" style="background-image: url('/img/euroaudit-services.jpg');">

		<div class="caption">
			<h1>Naše usluge</h1>
			<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit ed nec rutrum felis ed et mi sagittis mattis risu</p>
		</div>

	</div>

	<main>

		<!-- SECTION | Usluge revizije -->
		<section class="section-service bg-image padding-bottom" style="background-image: url('/img/usluge-revizije.jpg');">
			<div class="inner">

				<div class="section-heading heading-icon">
					<div><svg><use xlink:href="#icon-business-audit" /></svg></div>
					<h2>Usluge revizije</h2>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="column __8 lt__5">
							<div class="rich-text">
								<ul class="half-list">
									<li>Revizija finansijskih izveštaja</li>
									<li>Revizija konsolidovanih finansijskih izveštaja</li>
									<li>Revizija finansijskih izveštaja budžetskih korisnika</li>
									<li>Revizija UPPR-a</li>
									<li>Revizija po osnovu dokapitalizacije</li>
									<li>Revizija po osnovu privatizacije</li>
									<li>Revizija projekata donacija</li>
								</ul>
								<ul class="half-list">
									<li>Revizija projekata podsticaja razvoja (investicije i zapošljavanje)</li>
									<li>Revizija specijalnih bilansa (spajanja, pripajanja, podela, izdvajanja, stečaj, likvidacija)</li>
									<li>Revizija za specijalne svrhe</li>
									<li>Pregledi finansijskih izveštaja i informacija</li>
									<li>Angažovanja na osnovu kojih se pruža uveravanje</li>
								</ul>
							</div>
						</div>
					</div>
				</div>

				<div class="section-footer">
					<a href="#" class="button btn-secondary btn-ghost requestPopup_open"><span>zahtev za ponudom</span></a>
				</div>

			</div>
		</section>
		<!-- \\ SECTION | Usluge revizije -->

		<!-- SECTION | Konsultantske usluge -->
		<section class="section-service">
			<div class="inner">
				<div class="row">

					<div class="column __7 lt__3" data-mh="group-1">
						<div class="section-image">
							<img src="img/services-consulting.jpg" />
						</div>
					</div>

					<div class="column __5 lt__3" data-mh="group-1">
						<div class="vertical-align">
							<div class="section-heading heading-icon">
								<div><svg><use xlink:href="#icon-consulting" /></svg></div>
								<h2>Konsultantske usluge</h2>
							</div>
							<div class="section-body">
								<div class="rich-text">
									<ul>
										<li>Računovodstveni konsalting</li>
										<li>Konsalting vezan za restrukturiranje privrednih društava</li>
										<li>Izrada UPPR-a i usluge u vezi izvođenja UPPR-a</li>
										<li>Konsalting vezan za ekonomsko i finansijsko saniranje</li>
										<li>Finansijski konsalting</li>
										<li>Poreski konsalting</li>
										<li>Konsalting vezan za carinsko i devizno poslovanje</li>
									</ul>
								</div>
							</div>
							<div class="section-footer">
								<a href="#" class="button btn-secondary btn-ghost requestPopup_open"><span>zahtev za ponudom</span></a>
							</div>
						</div>
					</div>

				</div>
			</div>
		</section>
		<!-- \\ SECTION | Konsultantske usluge -->

		<!-- SECTION | Transferne cene -->
		<section class="section-service bg-image padding-bottom" style="background-image: url('/img/transferne-cene.jpg');">
			<div class="inner">

				<div class="section-heading heading-icon">
					<div><svg><use xlink:href="#icon-balance-audit" /></svg></div>
					<h2>Transferne cene</h2>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="column __8">
							<div class="rich-text">
								<p>Shodno smernicama OECD-a za primenu pravila o transfernim cenama za multinacionalna preduzeća i poreske uprave, Zakona o porezu na dobit pravnih lica u RS, kao i Pravilnika o transfernim cenama i metodama koje se po principu “van dohvata ruke” primenjuju kod utvrđivanja cena transakcija između povezanih lica, pružamo usluge: .Izrade Studije o transfernim cenama.</p>
							</div>
						</div>
					</div>
				</div>

				<div class="section-footer">
					<div class="license-block">
						<div><img src="/img/buearu-van-dijk.png" /></div>
						<div>
							<p>Posedujemo licence za korišćenje baza podataka</p>
							<h3>Amadeus – Transfer Pricing Catalyst (Bureau Van Dijk) i Scoring</h3>
						</div>
					</div>
					<a href="#" class="button btn-secondary btn-ghost requestPopup_open"><span>zahtev za ponudom</span></a>
				</div>

			</div>
		</section>
		<!-- \\ SECTION | Transferne cene -->

		<!-- SECTION | Ostale usluge -->
		<section class="section-service">
			<div class="inner">
				<div class="row">

					<div class="column __7 lt__3" data-mh="group-2">
						<div class="section-image">
							<img src="img/services-others.jpg" />
						</div>
					</div>

					<div class="column __5 lt__3" data-mh="group-2">
						<div class="vertical-align">
							<div class="section-heading heading-icon">
								<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
								<h2>Ostale usluge</h2>
							</div>
							<div class="section-body">
								<div class="rich-text">
									<ul>
										<li>Procena vrednosti preduzeća</li>
										<li>Procena vrednosti imovine</li>
										<li>Procena vrednosti kapitala</li>
										<li>Analiza finansijskih izveštaja i ocena boniteta preduzeća</li>
										<li>Projekti vezani za izvođenje reorganizacije društva u skladu sa Zakonom o privrednim društvima</li>
										<li>Izrada i ocena investicionih projekata</li>
										<li>Izrada projekata saniranja privrednih društava</li>
									</ul>
								</div>
							</div>
							<div class="section-footer">
								<a href="#" class="button btn-secondary btn-ghost requestPopup_open"><span>zahtev za ponudom</span></a>
							</div>
						</div>
					</div>

				</div>
			</div>
		</section>
		<!-- \\ SECTION | Ostale usluge -->

        <?php include('inc/clients.php'); ?>

	</main>

	<!-- POPUP -->
	<div id="requestPopup" class="popup">

		<div class="popup-heading">
			<h2>Zahtev za ponudom</h2>
			<a href="#" class="close-popup requestPopup_close"><img src="img/ic-close.png" /></a>
		</div>

		<div class="popup-body">

			<div class="form">

				<div class="row">
					<div class="column __4">
						<label class="inline">Naziv društva:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Matični broj:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt osoba:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt telefon:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Email adresa:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Izaberite uslugu:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" >
						</div>
					</div>
				</div>

			</div>

		</div>

		<div class="popup-footer">
			<div class="submit">
				<button class="button btn-primary"><span>Pošaljite zahtev</span></button>
			</div>
		</div>

	</div>
	<!-- POPUP -->

    <?php include('inc/footer.php'); ?>

	<script src="js/jquery-3.2.1.min.js"></script>
	<script src="js/jquery.popupoverlay.js"></script>
	<script src="js/jquery.matchHeight-min.js"></script>
	<script src="js/slick.min.js"></script>
	<script src="js/main.js"></script>

	<script type="text/javascript">
		$(document).ready(function(){

			if ($(window).width() <= 1024 && $(window).width() > 768) {
				$('.vertical-align').css({
					'position' : 'absolute',
					'top' : '50%',
					'margin-top' : -$('.vertical-align').outerHeight()/2
				});
			}

			$('.popup').popup({
				outline: true,
				focusdelay: 400,
				color: '#0b0c13',
				opacity: 0.7
			});

			$('.logos-block.slider').slick({
				slidesToShow: 5,
				slidesToScroll: 5,
				infinite: false,
				dots: true,
				prevArrow:"<div class='slick-prev'>",
				nextArrow:"<div class='slick-next'>",
				customPaging: function(slider, i) {
					return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
				}
			});

		});
	</script>

</body>
</html>