<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>EuroAudit</title>

	<link rel="stylesheet" href="/css/1-main.css" type="text/css" />
	<link rel="stylesheet" href="/css/2-slick.css" type="text/css" />

</head>

<body>

<?php include('img/icons/ea-icons.svg'); ?>

<?php include('inc/header.php'); ?>

<div class="hero home-hero parallax-window" data-parallax="scroll" data-image-src="img/euoraudit-revizija-finansijski-konsalting.jpg">
	<div class="caption">
		<h1>Preduzeće za reviziju, finansijski i računovodstveni konsalting</h1>
		<p>Naše konsultantske i revizorske usluge zasnovane su na principu kvalitet iznad forme, uz punu zastupljenost forme kao dokaza postupaka u radu i rezultata rada. Obavljamo delatnost više od 15 godina i verujemo da je uspeh da opstanemo odraz stručnog i profesionalnog rada</p>
		<a href="#" class="button btn-primary"><span>Pročitajte više</span></a>
	</div>
</div>

<main>

	<section class="license-section">
		<div class="inner">
			<div class="row">
				<div class="column __5"><p>Posedujemo licence za baze podataka</p></div>
				<div class="column __2"><img src="img/buearu-van-dijk.png" /></div>
				<div class="column __5"><h3>Amadeus  – Transfer Pricing Catalyst (Bureau Van dijk) i Scoring</h3></div>
			</div>
		</div>
	</section>

	<!-- SECTION | Usluge revizije i konstaltinga -->
	<section>
		<div class="inner">

			<div class="section-heading">
				<h2>Usluge revizije i konstaltinga</h2>
			</div>

			<div class="section-body">
				<div class="service-grid">
					<div class="row block-row __inline-row __4-block st__3-block">
						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
								<p>Revizije finansijskih izveštaja</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-business-audit" /></svg></div>
								<p>Revizije poslovanja</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-balance-audit" /></svg></div>
								<p> Revizije specijalnih bilansa</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-finance-building" /></svg></div>
								<p>Ocena kreditnog boniteta</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-transfer-prices" /></svg></div>
								<p>Usluga iz oblasti transfernih cena</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-accounting-services" /></svg></div>
								<p>Usluga iz oblasti računovodstva</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-property" /></svg></div>
								<p>Procene vrednosti imovine i kapitala</p>
							</article>
						</div>

						<div class="column">
							<article>
								<div><svg><use xlink:href="#icon-taxes" /></svg></div>
								<p>Usluga iz oblasti primene propisa za obračun i plaćanje poreza</p>
							</article>
						</div>
					</div>
				</div>
			</div>

			<div class="section-footer">
				<a href="#" class="button btn-primary"><span>Pročitajte više</span></a>
			</div>

		</div>
	</section>
	<!-- \\ SECTION | Usluge revizije i konstaltinga -->

	<!-- SECTION | Efikasno i brzo -->
	<section class="bg-image" style="background-image: url('img/fleksibilna-procena.jpg')">
		<div class="inner">

			<div class="section-heading">
				<h2>Efikasno i brzo</h2>
			</div>

			<div class="section-body">
				<div class="row">
					<div class="column __7">
						<div class="rich-text">
							<p>Uslovi privređivanja zahtevaju efikasnu, fleksibilnu, stručnu i blagovremenu procenu poslovnih aktivnosti radi donošenja poslovnih odluka vezanih za investiranje, zajedničko ulaganje, poslovanje na berzi, učešće na javnim tenderima...</p>
							<p>Poslovnom odlučivanju imanentna je analiza rizika ostvarenja očekivanih rezultata.</p>
							<p>Ovi razlozi potvrđuju dobru poslovnu praksu da vlasnici kapitala, kreditori i drugi poverioci ili učesnici u zajedničkim aranžmanima, akvizicijama, procenama imovine, obaveza i kapitala, angažuju specijalizovana privredna društva koja pružaju usluge revizije i poslovnog konsaltinga u cilju blagovremenog identifikovanja postojanja rizika, analiza postojećeg stanja i predlaganja najboljih rešenja da se ostvare planirani projekti, ciljevi...</p>
						</div>
					</div>
				</div>
			</div>

			<div class="section-footer">
				<a href="#" class="button btn-secondary btn-ghost"><span>Pročitajte više</span></a>
			</div>

		</div>
	</section>
	<!-- \\ SECTION | Efikasno i brzo -->

	<!-- SECTION | Nasi kapaciteti -->
	<section class="bg-blue">
		<div class="inner">

			<div class="section-heading">
				<h2>Naši kapaciteti i stručnost</h2>
				<p>Naše konsultantske i revizorske usluge zasnovane su na principu kvalitet iznad forme, uz punu zastupljenost forme kao dokaza postupaka u radu i rezultata rada. Obavljamo delatnost više od 15 godina i verujemo da je uspeh da opstanemo odraz stručnog i profesionalnog rada.</p>
			</div>

			<div class="section-body">
				<div class="counter-block">
					<div class="row">
						<div class="column __3 m__1">
							<article>
								<a href="#"><img src="img/icon-counter-briefcase.svg" /><span></span><em></em></a>
								<div class="count">500</div>
								<p>Klijenata</p>
							</article>
						</div>

						<div class="column __3 m__1">
							<article>
								<a href="#"><img src="img/icon-counter-people.svg" /><span></span><em></em></a>
								<div class="count">30</div>
								<p>Zaposlenih</p>
							</article>
						</div>

						<div class="column __3 m__1">
							<article>
								<a href="#"><img src="img/icon-counter-certificate.svg" /><span></span><em></em></a>
								<div class="count">12</div>
								<p>Sertifikovanih revizora</p>
							</article>
						</div>

						<div class="column __3 m__1">
							<article>
								<a href="#"><img src="img/icon-counter-phd.svg" /><span></span><em></em></a>
								<div class="count">6</div>
								<p>Doktora nauka</p>
							</article>
						</div>
					</div>
				</div>
			</div>

			<div class="section-footer">
				<a href="about.php" class="button btn-primary"><span>Pročitajte više</span></a>
			</div>

		</div>
	</section>
	<!-- \\ SECTION | Nasi kapaciteti -->

	<?php include('inc/clients.php'); ?>

	<!-- SECTION | Nasa izdanja -->
	<section class="bg-blur">
		<div class="inner">

			<div class="section-heading">
				<h2>Naša izdanja</h2>
			</div>

			<div class="section-body">
				<div class="edition-block slider">
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
					<article  data-mh="group-1">
						<div><img src="img/book.png" /></div>
						<h2>Analiza finansijskih izveštaja</h2>
						<p><strong>Autori:</strong> Prof. dr Jovan Rodić, Prof. dr Gordana Vukelić, Prof. dr Mirko Andrić</p>
						<p><strong>Izdavač:</strong> Proleter a.d. Bečej</p>
						<p><strong>Izdato:</strong> Bečej, 2011. godine</p>
					</article>
				</div>
			</div>

		</div>
	</section>
	<!-- \\ SECTION | Nasa izdanja -->

</main>

<?php include('inc/footer.php'); ?>

<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/parallax.min.js"></script>
<script src="js/slick.min.js"></script>
<script src="js/main.js"></script>

<script type="text/javascript">
	$(document).ready(function(){

		$('.logos-block.slider').slick({
			slidesToShow: 5,
			slidesToScroll: 5,
			infinite: false,
			dots: true,
			prevArrow:"<div class='slick-prev'>",
			nextArrow:"<div class='slick-next'>",
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			},
			responsive: [
				{
					breakpoint: 770,
					settings: {
						slidesToShow: 3,
						slidesToScroll: 3,
						dots: true
					}
				},
				{
					breakpoint: 400,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 2,
						dots: true
					}
				}
			]
		});

		$('.edition-block.slider').slick({
			slidesToShow: 4,
			slidesToScroll: 4,
			infinite: false,
			dots: true,
			arrows: false,
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			},
			responsive: [
				{
					breakpoint: 770,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 2,
						dots: true
					}
				},
				{
					breakpoint: 400,
					settings: {
						slidesToShow: 1,
						slidesToScroll: 1,
						dots: true
					}
				}
			]
		});

	});
</script>

</body>
</html>