<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>EuroAudit</title>

	<link rel="stylesheet" href="/css/1-main.css" type="text/css" />
	<link rel="stylesheet" href="/css/2-slick.css" type="text/css" />

</head>

<body>

	<?php include('img/icons/ea-icons.svg'); ?>

    <?php include('inc/header.php'); ?>

	<div class="hero page-hero" style="background-image: url('/img/euroaudit-contact.jpg');">

		<div class="caption">
			<h1>Kontaktirajte nas</h1>
			<p>Bila bi nam čast i zadovoljstvo da nas posetite i saznate i druge detalje vezane za delatnost koju obavljamo.</p>
		</div>

	</div>

	<main>

		<section class="contact-section">

			<div class="inner">
				<div class="row">
					<div class="column __5 lt__6">

						<div class="contact-info">
							<h2>EuroAudit d.o.o.</h2>
							<p><strong>Adresa:</strong> Despota Stefana 12/5, 11000 Beograd, Srbija</p>
							<p><strong>Telefoni:</strong> +381 11 3347-421; 011 2627-612; 011 3284-019</p>
							<p><strong>Fax:</strong> 011 2629-821</p>
							<p><strong>Email:</strong> <a href="mailot:office@euaudit.com">office@euaudit.com</a></p>
						</div>

						<div class="form contact-form">
							<div class="field">
								<input type="text" placeholder="Ime i prezime" class="input" />
							</div>
							<div class="field">
								<input type="text" placeholder="Email adresa" class="input" />
							</div>
							<div class="field">
								<textarea placeholder="Vaša poruka" class="input"></textarea>
							</div>
							<div class="submit">
								<button class="button btn-primary"><span>Pošaljite poruku</span></button>
							</div>
						</div>

					</div>
				</div>
			</div>

			<div class="map" id="gmap">asd</div>

		</section>

        <?php include('inc/quote.php'); ?>

        <?php include('inc/clients.php'); ?>

	</main>

    <?php include('inc/footer.php'); ?>

	<script src="js/jquery-3.2.1.min.js"></script>
	<script src="js/slick.min.js"></script>
	<script src="js/main.js"></script>
	<script async defer src="//maps.googleapis.com/maps/api/js?key=AIzaSyADitNRqR-TpmBtxSDEBubM03cM0RBZTxE&callback=initMap"></script>
	<script type="text/javascript">
		function initMap() {
			var myOptions = {
				zoom: 17,
				center: new google.maps.LatLng(44.816508, 20.462993),
				scrollwheel: false,
				mapTypeId: google.maps.MapTypeId.ROADMAP };
			var map = new google.maps.Map(document.getElementById("gmap"), myOptions);

			var marker = new google.maps.Marker({
				position: new google.maps.LatLng(44.816508, 20.462993),
				map: map,
				icon:'/img/pin.png',
				animation: google.maps.Animation.DROP
			});
		}
	</script>

	<script type="text/javascript">
		$(document).ready(function(){

			$('.logos-block.slider').slick({
				slidesToShow: 5,
				slidesToScroll: 5,
				infinite: false,
				dots: true,
				prevArrow:"<div class='slick-prev'>",
				nextArrow:"<div class='slick-next'>",
				customPaging: function(slider, i) {
					return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
				}
			});

		});
	</script>



</body>
</html>