<!doctype html>
<html lang="en">
<head>
	<meta charset="utf-8" />
	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>EuroAudit</title>

	<link rel="stylesheet" href="/css/1-main.css" type="text/css" />
	<link rel="stylesheet" href="/css/2-slick.css" type="text/css" />

</head>

<body>

	<?php include('img/icons/ea-icons.svg'); ?>

    <?php include('inc/header.php'); ?>

	<div class="hero page-hero" style="background-image: url('/img/hero-about.jpg');">
		<div class="caption">
			<h1>O nama</h1>
			<p>Iako relativno mlado naše preduzeće iza sebe ima značajne rezultate u raznim oblastima</p>
		</div>
	</div>

	<main>

		<!-- SECTION | Nase usluge -->
		<section class="bg-pattern">
			<div class="inner">

				<div class="section-heading">
					<h2>Naše usluge</h2>
					<p>Privredno društvo EuroAudit doo. Beograd osnovano je u avgustu 2001. godine na osnovu licence Ministarstva finansija SCG br. <a href="#">5/2-03-0004/01</a> za obavljanje delatnosti pružanja usluga revizije, finansijskog, računovodstvenog i konsaltinga u vezi sa porezima. Kontinuitet u obavljanju registrovane delatnosti podržan je dozvolom Ministarstva finansija Republike Srbije broj <a href="#">401-00-2369/2014-16</a> od 23. jula 2014. godine u skladu sa Zakonom o reviziji („Sl. glasnik RS“ 62/2013)</p>
				</div>

				<div class="section-body">
					<div class="default-grid small-grid">
						<div class="row block-row __inline-row __4-block m__2-block">

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Revizije finansijskih izveštaja</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Revizije poslovanja</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Revizije specijalnih bilansa</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Ocena kreditnog boniteta</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Usluga iz oblasti transfernih cena</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Usluga iz oblasti računovodstva</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Procene vrednosti imovine i kapitala</p>
								</article>
							</div>

							<div class="column">
								<article>
									<div><svg><use xlink:href="#icon-financial-audit" /></svg></div>
									<p>Usluga iz oblasti primene propisa za obračun i plaćanje poreza</p>
								</article>
							</div>

						</div>
					</div>
				</div>

				<div class="section-footer">
					<a href="#" class="button btn-primary"><span>Više o uslugama</span></a>
				</div>

			</div>
		</section>
		<!-- \\ SECTION | Nase usluge -->

		<!-- SECTION | Nasi zadovoljni klijenti -->
		<section class="bg-image" style="background-image: url('/img/zadovoljni-klijenti.jpg');">
			<div class="inner">

				<div class="section-heading">
					<h2>Naši zadovoljni klijenti</h2>
				</div>

				<div class="section-body">
					<div class="row">
						<div class="column __7">
							<div class="rich-text">
								<p>Preduzece je dobilo dozvolu za obavljanje poslova revizije finansijskih izvestaja velikih i srednjih preduzeca Republike Srbije broj <a href="#">401-00-2369/2014-16</a> od 23. jula 2014. godine u skladu sa Zakonom o računovodstvu i reviziji (Sl. glasnik RS 62/2013). Iako relativno mlado naše preduzeće iza sebe ima značajne rezultate u oblasti:</p>
							</div>
						</div>
					</div>
				</div>

			</div>
		</section>
		<!-- SECTION | \\Nasi zadovoljni klijenti -->

		<!-- SECTION | Nasi kapaciteti -->
		<section class="bg-blue">
			<div class="inner">

				<div class="section-heading">
					<h2>Naši kapaciteti i stručnost</h2>
					<p>Naše konsultantske i revizorske usluge zasnovane su na principu kvalitet iznad forme, uz punu zastupljenost forme kao dokaza postupaka u radu i rezultata rada. Obavljamo delatnost više od 15 godina i verujemo da je uspeh da opstanemo odraz stručnog i profesionalnog rada.</p>
				</div>

				<div class="section-body">
					<div class="counter-block">
						<div class="row">
							<div class="column __3 m__1">
								<article>
									<a href="#"><img src="img/icon-counter-briefcase.svg" /><span></span><em></em></a>
									<div class="count">500</div>
									<p>Klijenata</p>
								</article>
							</div>

							<div class="column __3 m__1">
								<article>
									<a href="#"><img src="img/icon-counter-people.svg" /><span></span><em></em></a>
									<div class="count">30</div>
									<p>Zaposlenih</p>
								</article>
							</div>

							<div class="column __3 m__1">
								<article>
									<a href="#"><img src="img/icon-counter-certificate.svg" /><span></span><em></em></a>
									<div class="count">12</div>
									<p>Sertifikovanih revizora</p>
								</article>
							</div>

							<div class="column __3 m__1">
								<article>
									<a href="#"><img src="img/icon-counter-phd.svg" /><span></span><em></em></a>
									<div class="count">6</div>
									<p>Doktora nauka</p>
								</article>
							</div>
						</div>
					</div>
				</div>

			</div>
		</section>
		<!-- \\ SECTION | Nasi kapaciteti -->

        <?php include('inc/quote.php'); ?>

        <?php include('inc/clients.php'); ?>

	</main>

    <?php include('inc/footer.php'); ?>

	<script src="js/jquery-3.2.1.min.js"></script>
	<script src="js/slick.min.js"></script>
	<script src="js/main.js"></script>

	<script type="text/javascript">
		$(document).ready(function(){

			$('.logos-block.slider').slick({
				slidesToShow: 5,
				slidesToScroll: 5,
				infinite: false,
				dots: true,
				prevArrow:"<div class='slick-prev'>",
				nextArrow:"<div class='slick-next'>",
				customPaging: function(slider, i) {
					return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
				}
			});

		});
	</script>

</body>
</html>