<?php
	$grayUrl = "getUserVariable('GrayBlocUrl', 'string')";

	$listServices = ClassRegistry::init('ListService')->find('all', []);
?>

<section class="bg-pattern">
	<div class="inner">
		<div class="section-heading">
			<h2 cms="block" type="string" name="Title"></h2>
			<code cms="block" type="custom" name="Intro"></code>
		</div>

		<div class="section-body">
			<div class="default-grid small-grid">
				<div class="row block-row __4-block m__2-block">
					<?php foreach ($listServices as $listService) { ?>
						<div class="column">
							<article>
								<div><img src="<?= $listService['Icon']['file'] ?>" /></div>
								<p><?= $listService['ListService']['title'] ?></p>
							</article>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>

		<div class="section-footer">
			<a href="<?= $this->Format->getPageFromSitemap(5, $sitemap, 'path')?>" class="button btn-primary"><span><?php echo __('Više o uslugama') ?></span></a>
		</div>
	</div>
</section>

<section class="bg-image" style="background-image: url(/img/zadovoljni-klijenti.jpg);">
	<div class="inner">

		<div class="section-heading">
			<h2 cms="block" type="string" name="GrayBlockTitle"></h2>
		</div>
		<div class="section-body">
			<div class="row">
				<div class="column __7 st__6">
					<div class="rich-text">
						<code cms="block" type="custom" name="GrayBlockText"></code>
					</div>
				</div>
			</div>
		</div>

		<div class="section-footer">
			<a href="<?= $grayUrl ?>" class="button btn-secondary btn-ghost"><span><?php echo __('Pročitajte više') ?></span></a>
		</div>
	</div>
</section>