<?php
	$publications = ClassRegistry::init('Publication')->find('all', []);
?>
<section class="bg-blur">
	<div class="inner">
		<div class="section-heading">
			<h2><?php echo __('Naša izdanja') ?></h2>
		</div>
		<div class="section-body">
			<div class="edition-block slider">
				<?php foreach ($publications as $publication) { ?>
					<article data-mh="group-publication">
						<div><img src="<?= $this->Manicure->match($publication['Image']['file'], 80, 128)?>" /></div>
						<h2><?= $publication['Publication']['title']?></h2>
						<p><strong><?php echo __('Autori:') ?></strong> <?= $publication['Publication']['author']?></p>
						<p><strong><?php echo __('Izdavač:') ?></strong> <?= $publication['Publication']['publisher']?></p>
						<p><strong><?php echo __('Izdato:') ?></strong> <?= $publication['Publication']['published']?></p>
					</article>
				<?php } ?>
			</div>
		</div>
	</div>
</section>
<script type="text/javascript">
	methodStack.push(function () {
		$('.edition-block.slider').slick({
			slidesToShow: 4,
			slidesToScroll: 4,
			infinite: false,
			dots: true,
			arrows: false,
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			},
			responsive: [
				{
					breakpoint: 770,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 2,
						dots: true
					}
				},
				{
					breakpoint: 400,
					settings: {
						slidesToShow: 1,
						slidesToScroll: 1,
						dots: true
					}
				}
			]
		});
	})
</script>