<?php
	$clients = ClassRegistry::init('Client')->find('all', [
		'conditions' => [
			'Client.show_in_carousel' => true
		],
		'order' => 'Client.carousel_priority ASC'
	]);
?>

<section class="border-top">
	<div class="inner">
		<div class="section-heading">
			<h2 cms="block" type="string" name="BlueBlockTitle"></h2>
			<p cms="block" type="string" name="BlueBlockText"></p>
		</div>
		<div class="section-body">
			<div class="logos-block slider">
				<?php foreach ($clients as $client) { ?>
					<article><img src="<?= $client['Logo']['file'] ?>" /></article>
				<?php } ?>
			</div>
		</div>

		<div class="section-footer">
			<a href="<?= $this->Format->getPageFromSitemap(6, $sitemap, 'path')?>" class="button btn-ghost btn-secondary"><span><?php echo __('Pogledajte sve naše klijente') ?></span></a>
		</div>
	</div>
</section>

<script type="text/javascript">

	methodStack.push(function () {
		$('.logos-block.slider').slick({
			slidesToShow: 5,
			slidesToScroll: 5,
			infinite: false,
			dots: true,
			prevArrow:"<div class='slick-prev'>",
			nextArrow:"<div class='slick-next'>",
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			},
			responsive: [
				{
					breakpoint: 770,
					settings: {
						slidesToShow: 3,
						slidesToScroll: 3,
						dots: true
					}
				},
				{
					breakpoint: 400,
					settings: {
						slidesToShow: 2,
						slidesToScroll: 2,
						dots: true
					}
				}
			]
		});
	})

</script>
