<?php
$clientCategories = ClassRegistry::init('ClientCategory')->find('all', []);
$clients = ClassRegistry::init('Client')->find('all', [
	'order' => 'Client.ordering ASC'
]);

$packedClients = [];

foreach ($clientCategories as $i => $clientCategory) {
	$packedClients[$i]['title'] = $clientCategory['ClientCategory']['title'];
	foreach ($clients as $client) {
		if($client['Client']['cms_client_category_id'] === $clientCategory['ClientCategory']['id']) {
			$packedClients[$i]['clients'][] = $client;
		}
	}
};

?>

<section class="bg-pattern">
	<div class="inner">
		<div class="clients-grid">
			<?php foreach ($packedClients as $i => $category) { ?>
				<div class="clients-grid-block">
					<h2><?= $category['title'] ?></h2>
					<div class="row __inline-row block-row __5-block st__3-block">
						<?php foreach ($packedClients[$i]['clients'] as $client) { ?>
							<div class="column">
								<article data-mh="group-1">
									<div><img src="<?= $client['Logo']['file'] ?>" /></div>
									<h3><?= $client['Client']['title'] ?></h3>
									<p><?= $client['Client']['industry'] ?></p>
									<p><?= $client['Client']['city'] ?></p>
								</article>
							</div>
						<?php } ?>
					</div>
				</div>
			<?php } ?>
		</div>
	</div>
</section>

