<?php
// Load Composer's autoloader
require ROOT . '/vendor/phpmailer/phpmailer/src/Exception.php';
require ROOT . '/vendor/phpmailer/phpmailer/src/PHPMailer.php';
require ROOT . '/vendor/phpmailer/phpmailer/src/SMTP.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

$mail = new PHPMailer(true);

$services = ClassRegistry::init('Service')->find('all', []);
?>

<?php
if (!empty($_POST)) {
    if (!empty($_POST['data']['name'])) {
		$name = $_POST['data']['name'];
		echo $name;
    }
}
if (isset($_POST['data'])) {
	   //honey pot field
	   $honeypot = $_POST['firstname'];

	   //check if the honeypot field is filled out. If not, send a mail.
	   if(!empty($honeypot)){
		  return; //you may add code here to echo an error etc.
		  // echo "Robot go away!";
		  // header('Location: https://google.com');
	   }else{ 

// Get $_POST['data']
$name = $_POST['data']['name'];
$registration_number = $_POST['data']['registration_number'];
$contact_person = $_POST['data']['contact_person'];
$phone = $_POST['data']['phone'];    
$email = $_POST['data']['email'];
$dateOffer = date('d.m.Y. H:i');

switch ($_POST['data']['cms_service_id']) {
case '1':
    $service = "Usluge revizije";
break;
case '2':
    $service = "Konsultantske usluge";
break;
case '3':
    $service = "Transferne cene";
break;
case '4':
    $service = "Ostale usluge";
break;
} 

$from_title = "$name | MBR: $registration_number";
$subject_title = "Zahtev za ponudom - $service - $contact_person | $phone";

$htmlBody = '<!DOCTYPE html>
<html lang="sr">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta http-equiv="X-UA-Compatible" content="ie=edge">
<title>*|MC:SUBJECT|*</title>
<style>
*,::after,::before{box-sizing:border-box;}
body{margin:0;font-family:-apple-system,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,"Noto Sans",sans-serif,"Apple Color Emoji","Segoe UI Emoji","Segoe UI Symbol","Noto Color Emoji";font-size:1rem;font-weight:400;line-height:1.5;color:#212529;text-align:left;background-color:#fff;}
h4{margin-top:0;margin-bottom:.5rem;}
b{font-weight:bolder;}
a{color:#007bff;text-decoration:none;background-color:transparent;}
a:hover{color:#0056b3;text-decoration:underline;}
img{vertical-align:middle;border-style:none;}
table{border-collapse:collapse;}
th{text-align:inherit;}
h4{margin-bottom:.5rem;font-weight:500;line-height:1.2;}
h4{font-size:1.5rem;}
.container{width:100%;padding-right:15px;padding-left:15px;margin-right:auto;margin-left:auto;}
@media only screen and (max-width: 480px){
table,td,a{-webkit-text-size-adjust:none!important;}
.footerContent{font-size:14px!important;line-height:115%!important;}
.footerContent a{display:block!important;}
}
@media (min-width:576px){
.container{max-width:540px;}
}
@media (min-width:768px){
.container{max-width:720px;}
}
@media (min-width:992px){
.container{max-width:960px;}
}
@media (min-width:1200px){
.container{max-width:1140px;}
}
.table{width:100%;margin-bottom:1rem;color:#212529;}
.table th{padding:.75rem;vertical-align:top;border-top:1px solid #dee2e6;}
.table thead th{vertical-align:bottom;border-bottom:2px solid #dee2e6;}
.card{position:relative;display:-ms-flexbox;display:flex;-ms-flex-direction:column;flex-direction:column;min-width:0;word-wrap:break-word;background-color:#fff;background-clip:border-box;border:1px solid rgba(0,0,0,.125);border-radius:.25rem;}
.card-header{padding:.75rem 1.25rem;margin-bottom:0;background-color:rgba(0,0,0,.03);border-bottom:1px solid rgba(0,0,0,.125);}
.card-header:first-child{border-radius:calc(.25rem - 1px) calc(.25rem - 1px) 0 0;}
.my-2{margin-top:.5rem!important;}
.my-2{margin-bottom:.5rem!important;}
.my-4{margin-top:1.5rem!important;}
.my-4{margin-bottom:1.5rem!important;}
.mb-5{margin-bottom:3rem!important;}
@media print{
*,::after,::before{text-shadow:none!important;box-shadow:none!important;}
a:not(.btn){text-decoration:underline;}
thead{display:table-header-group;}
img,tr{page-break-inside:avoid;}
body{min-width:992px!important;}
.container{min-width:992px!important;}
.table{border-collapse:collapse!important;}
.table th{background-color:#fff!important;}
}
</style>    
</head>
<body>   
<div class="container">
<div class="card my-4">
<div class="card-header">
<h4>Zahtev za ponudom</h4>
</div>
</div>
<table class="table">
<thead>
<tr>
<th scope="col">Naziv društva:</th>
<th scope="col">'. $name . '</th>
</tr>
<tr>
<th scope="col">Matični broj:</th>
<th scope="col">'. $registration_number . '</th>
</tr>
<tr>
<th scope="col">Kontakt osoba:</th>
<th scope="col">'. $contact_person . '</th>
</tr>
<tr>
<th scope="col">Kontakt telefon:</th>
<th scope="col"><a href="tel:'. $phone .'">'. $phone .'</a></th>
</tr>
<tr>
<th scope="col">Email adresa:</th>
<th scope="col"><a href="mailto:'. $email .'">'. $email .'</a></th>
</tr>
<tr>
<th scope="col">Izabrana usluga:</th>
<th scope="col">
'. $service .'
</th>
<tr>
<th scope="col">Datum i vreme prijema:</th>
<th scope="col">'. $dateOffer .'</th>
</tr>
</tr>
</thead>
</table>
<p>Poslato pomoću forme - Zahtev za ponudom</p>

<td valign="top" class="footerContent" style="padding-top:0;">
<p>Copyright © '. date('Y') .' EuroAudit All rights reserved.</p>
</td>
</div>
</body>
</html>
';
$altBodyText = "Zahtev za ponudom<br>Naziv društva: $name<br>Matični broj: $registration_number<br>Kontakt osoba: $contact_person<br>Kontakt telefon: $phone<br>Email adresa: $email<br>Izabrana usluga: $service<br>Datum i vreme prijema: $dateOffer<br>";

// echo (extension_loaded('openssl')?'SSL loaded':'SSL not loaded')."\n";
try {    
    //Server settings
    $mail->SMTPDebug = SMTP::DEBUG_SERVER;                      // Enable verbose debug output
    $mail->isSMTP();                                            // Send using SMTP
    $mail->Host       = 'mail.euaudit.com';                     // Set the SMTP server to send through
    $mail->SMTPAuth   = true;                                   // Enable SMTP authentication
    $mail->Username   = 'zahtevi@euaudit.com';                  // SMTP username
    $mail->Password   = 'Q]rQ0TE[};O]GpLrA?';                            // SMTP password  
    $mail->SMTPSecure = 'ssl';                                  // $mail->SMTPSecure = 'ssl'; $mail->SMTPSecure = 'tls';
    $mail->SMTPAutoTLS = false;
    $mail->Port       = 465;                                    // TCP port to connect to
    
    //Recipients
    $mail->setFrom('zahtevi@euaudit.com', $from_title);
    $mail->addAddress('zahtevi@euaudit.com', 'Zahtev za ponudom');     // Add a recipient
    // $mail->addAddress($email, $contact_person);               // Name is optional
    $mail->addReplyTo($email, $contact_person);
    // $mail->addCC('cc@example.com');
    // $mail->addBCC('bcc@example.com');
    // $mail->addBCC('pavle.dakic@euaudit.com');

    // Content
    $mail->isHTML(true);                                    // Set email format to HTML
    $mail->Encoding = 'base64';                             // $mail->Encoding = "16bit";    
    $mail->CharSet = "utf-8";
    $mail->Subject = $subject_title;    
    $mail->Body    = $htmlBody;                             // HTML body content
	$mail->AltBody = $altBodyText; // This is the body in plain text for non-HTML mail clients
	
	echo $mail->Body;

    // Send Email
    //$mail->send();
    echo 'Message has been sent';
} catch (Exception $e) {
    echo "Message could not be sent. Mailer Error: {$mail->ErrorInfo}";
} 
}
}
?>
<?php if(isset($_GET['sending']) == true){ ?>
	<div class="form-message-success">Message sent succesfully</div>
<?php } ?>

<?php foreach ($services as $i => $service) { ?>
	<section class="section-service<?= $i % 2 !== 0 ? '' : ' bg-image padding-bottom'?>" style="background-image: url(<?= $i % 2 == 0 ? $service['Image']['file'] : '' ?>);" id="<?= str_replace(' ', '', $service['Service']['title'])?>">
		<div class="inner">
			<?php if($i % 2 !== 0 ) { ?>
				<div class="row">
					<div class="column __7 lt__3 st__6" data-mh="group-1">
						<div class="section-image">
							<img src="<?= $service['Image']['file'] ?>" />
						</div>
					</div>
					<div class="column __5 lt__3 st__6" data-mh="group-1">
						<div class="vertical-align">
							<div class="section-heading heading-icon">
								<div><img src="<?= $service['Icon']['file'] ?>" /></div>
								<h2><?= $service['Service']['title'] ?></h2>
							</div>
			<?php } else { ?>
				<div class="section-heading heading-icon">
					<div><img src="<?= $service['Icon']['file'] ?>" /></div>
					<h2><?= $service['Service']['title'] ?></h2>
				</div>
				<div class="section-body">
					<div class="row">
						<div class="column __8 lt__5 st__6">
			<?php } ?>
							<div class="section-body">
								<div class="rich-text">
									<?= $service['Service']['description'] ?>
								</div>
							</div>
			<?php if($i % 2 == 0 ) { ?>
						</div>
					</div>
				</div>
						<?php } ?>
							<div class="section-footer">
								<?php if($service['Service']['additional_block']) { ?>
									<?php if(empty($service['AdditionalBlockFile' . ucfirst($locale)]['file'])) { ?>
										<div class="license-block">
											<?php if(!empty($service['AdditionalBlockImage']['file'])) { ?>
												<div><img src="<?= $service['AdditionalBlockImage']['file'] ?>" /></div>
											<?php } ?>
											<div>
												<p><?= $service['Service']['additional_block_title'] ?></p>
												<h3><?= $service['Service']['additional_block_text'] ?></h3>
											</div>
										</div>
									<?php } else { ?>
										<a href="<?= $service['AdditionalBlockFile' . ucfirst($locale)]['file'] ?>" class="license-block" target="_blank">
                                            <?php if(!empty($service['AdditionalBlockImage']['file'])) { ?>
												<div><img src="<?= $service['AdditionalBlockImage']['file'] ?>" /></div>
                                            <?php } ?>											<div>
												<p><?= $service['Service']['additional_block_title'] ?></p>
												<h3><?= $service['Service']['additional_block_text'] ?></h3>
											</div>
										</a>
                                    <?php } ?>
                                <?php } ?>
								<div><a href="javascript:void(0)" class="button btn-secondary btn-ghost requestPopup_open" data-popup-id="<?= $service['Service']['id'] ?>"><span><?php echo __('zahtev za ponudom') ?></span></a></div>
							</div>
			<?php if($i % 2 === 0 ) { ?>
						</div>
					</div>
				</div>
			<?php } ?>
		</div>
	</section>
<?php } ?>

<div id="requestPopup" class="popup">
	<div class="popup-heading">
		<h2>Zahtev za ponudom</h2>
		<a href="javascript:void(0)" class="close-popup requestPopup_close"><img src="/img/ic-close.png" /></a>
	</div>
<?php
// echo '<pre>';
// print_r($_POST);
// echo '</pre>';

// echo '<pre>';
// print_r($model);
// echo '</pre>';
?>
	<!-- /api/v1/request -->
	<form method="post" action="/api/v1/request" id="RequestForm">
		<div class="popup-body">

			<div class="form">
				<div class="row">
					<div class="column __4">
						<label class="inline">Naziv društva:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input name="firstname" type="text" id="firstname" style="display: none">
							<input type="text" class="input" data-a="<?php echo $name; ?>" name="data[name]" value="<?php echo $name; ?>"/>
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Matični broj:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[registration_number]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt osoba:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[contact_person]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Kontakt telefon:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="tel" class="input" name="data[phone]"  placeholder="+381 6x xxx xx xx" pattern="^(\+)[0-9]?(?=(.*?\d){10,})( ?\(\d+\))?[ \d]+(#\d+)?$" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Email adresa:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<input type="text" class="input" name="data[email]" />
						</div>
					</div>
				</div>

				<div class="row">
					<div class="column __4">
						<label class="inline">Izaberite uslugu:</label>
					</div>
					<div class="column __8">
						<div class="field">
							<select name="data[cms_service_id]" class="input" data-service-id>
								<?php foreach ($services as $service) { ?>
									<option value="<?= $service['Service']['id'] ?>"><?= $service['Service']['title'] ?></option>
								<?php } ?>
							</select>
						</div>
					</div>
				</div>
			</div>
		</div>

		<div class="popup-footer">
			<div class="submit">
				<button class="button btn-primary" type="submit"><span>Pošaljite zahtev</span></button>
				<div class="form-message"></div>
			</div>
		</div>
	</form>
</div>
	<!-- POPUP -->

<script type="text/javascript">
	methodStack.push(function () {

		if ($(window).width() <= 1024 && $(window).width() > 768) {
			$('.vertical-align').css({
				'position' : 'absolute',
				'top' : '50%',
				'margin-top' : -$('.vertical-align').outerHeight()/2
			});
		}

		$('[data-popup-id]').click(function () {
			$('[data-service-id]').val($(this).data('popup-id'))
		});

		$('.popup').popup({
			outline: true,
			focusdelay: 400,
			color: '#0b0c13',
			opacity: 0.7
		});

		$('.logos-block.slider').slick({
			slidesToShow: 5,
			slidesToScroll: 5,
			infinite: false,
			dots: true,
			prevArrow:"<div class='slick-prev'>",
			nextArrow:"<div class='slick-next'>",
			customPaging: function(slider, i) {
				return $('<div data-role="none" role="button" tabindex="0" />').text(i + 1);
			}
		});

		$('#RequestForm').intlxform();
	});
</script>
<script src="https://www.google.com/recaptcha/api.js?render=6Ldqxr4UAAAAAK1TGyJw4srCs0jSdpPVUP_wtgtV"></script>
<script>
grecaptcha.ready(function() {
    grecaptcha.execute('6Ldqxr4UAAAAAK1TGyJw4srCs0jSdpPVUP_wtgtV', {action: '/api/v1/request'}).then(function(token) {
    });
});
</script>