<?php

class FrontHelper extends FormatHelper {

	var $months = [ '[01]' => 'Januar', '[02]' => 'Februar', '[03]' => 'Mart', '[04]' => 'April', '[05]' => 'Maj', '[06]' => 'Jun', '[07]' => 'Jul', '[08]' => 'Avgust', '[09]' => 'Septembar', '[10]' => 'Oktobar', '[11]' => 'Novembar', '[12]' => 'Decembar' ];

	var $days = [ '[1]' => 'Ponedeljak', '[2]' => 'Utorak', '[3]' => 'Sreda', '[4]' => 'Četvrtak', '[5]' => 'Petak', '[6]' => 'Subota', '[7]' => 'Nedelja' ];

	# ~ Shows the date in a fancy and cool format  - - - - - - - - - - - - - - - - #
	public function fancyDate($time) {
		ob_start();
		?>
		<span class="date">
					<span><?= (int) substr($time, 8, 2) ?></span>
					<em><?= str_replace('avg', 'aug', str_replace('may', 'maj', str_replace('oct', 'okt', strtolower(date('M', strtotime($time)))))) ?></em>
				</span>
		<?php
		return ob_get_clean();
	}

	public function youtubeEmbed($url) {
		$code = $this->youtubeCode($url);
		return 'https://www.youtube.com/embed/' . $code;
	}

	public function youtubeCode($url) {
		if (preg_match("#(?<=v=)[a-zA-Z0-9-]+(?=&)|(?<=v\/)[^&\n]+(?=\?)|(?<=v=)[^&\n]+|(?<=youtu.be/)[^&\n]+#", $url, $matches)) {
			return $matches[0];

		}

		return null;
	}
}
