<?php
class MetaTag extends SeoAppModel {
	var $useTable = 'seo_meta_tags';


# ~ Get all tags - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getAll($rawTags = array()) {
		if(empty($rawTags)) {
			$rawTags = $this->find('all', array(
				'order' => array(
					'namespace' => 'ASC',
					'name' => 'ASC'
				)
			));
		}

		$tags = array();
		foreach($rawTags as $rawTag) {
			$rawTag = reset($rawTag);
			$fullTagName = $rawTag['name'];

			if(!empty($rawTag['namespace'])) {
				$fullTagName = $rawTag['namespace'] . ':' . $fullTagName;
			}

			$fullTagName = $rawTag['type'] . ':' . $fullTagName;

			foreach(array('created', 'modified') as $unsetField) {
				unset($rawTag[$unsetField]);
			}

			$tags[$fullTagName] = $rawTag;
		}
		return $tags;
	}


# ~ Get all formatted by id- - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getAllById() {
		return $this->formatList($this->find('all'), 'id');
	}


# ~ Pack tags for serialization in module or page- - - - - - - - - - - - - - - #
	public function packTags($items) {
		$metaTags = $this->formatList($this->find('all'), 'id');

		$tags = array();

		foreach($items as $tagId => $tagValues) {
			if(!isset($metaTags[$tagId])) {
				continue;
			}
			$tags = array($metaTags[$tagId]['id'] => $tagValues) +	$tags;
		}
		return serialize($tags);
	}


# ~ Get meta tags for form - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getForForm($serialized) {
		# Unserialize tags
		$metaTags = @unserialize($serialized);

		# If no tags
		if(!$metaTags) {
			return array();
		}

		# Extract tags for form
		$tags = array();
		foreach($metaTags as $id => $values) {
			$tags[$id] = $values;
		}
		return $tags;
	}


# ~ Get for select - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function getForList($conditions = array()) {
		$metaTags = $this->find('all', compact('conditions'));

		$formatted = array();

		foreach($metaTags as $metaTag) {
			$metaTag = reset($metaTag);
			$formatted[$metaTag['id']] = !empty($metaTag['namespace']) ? ($metaTag['namespace'] . ':' . $metaTag['name']) : $metaTag['name'];
			$formatted[$metaTag['id']] = $metaTag['type'] . ' - ' . $formatted[$metaTag['id']];
		}

		return $formatted;
	}


# ~ Format tag list by field - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function formatList($items, $field) {
		$newList = array();
		foreach($items as $item) {
			$newList[$item[$this->alias][$field]] = $item[$this->alias];
		}
		return $newList;
	}


# ~ Parse one tag for serialization- - - - - - - - - - - - - - - - - - - - - - #
	private function parseTag($tagDescription, $tagValues) {
		$tag = array();
		return array(
			$tagDescription['id'] => $tagValues
		);
	}


# ~ Extract generated metatags for page- - - - - - - - - - - - - - - - - - - - #
	public function extractGeneratedTags($page) {
		if(!isset($page['Page']['seo_generated_metatags'])) return array();

		$generated = (array)$page['Page']['seo_generated_metatags'];
		foreach($generated as $id => $values) {
			if(!is_array($values)) {
				continue;
			}
			$values = array_filter($values);
			if(empty($values)) {
				unset($generated[$id]);
			}
		}
		return $generated;
	}
}
