<?php
class SlugLoggedBehavior extends ModelBehavior {

	private $locale = null;
	private $languages = [];
	private $slugBackup = [];


# ~ Setup behavior, load language vars - - - - - - - - - - - - - - - - - - - - #
	public function setup(Model $Model, $options = []) {
		$this->languages = Configure::read('Config.Languages');
		$this->locale = Configure::read('Config.Language');
	}


# ~ Backup old slug values - - - - - - - - - - - - - - - - - - - - - - - - - - #
	public function beforeSave(Model $Model, $options = []) {
		$this->slugBackup = $this->extractSlug($Model, $Model->previousData);

		# Backup parent id
		if($Model->name == 'Page') {
			$this->parentBackup = $Model->previousData[$Model->alias]['parent_id'];
		}
		return true;
	}


# ~ Get new slug values and compare with old ones- - - - - - - - - - - - - - - #
	public function afterSave(Model $Model, $created = false, $options = []) {
		# Do not monitor new ones
		if($created) {
			return true;
		}

		if(!empty($Model->data[$Model->alias]['is_deleted'])) {
			return true;
		}

		# Get current slug values
		$currentSlug = $this->extractSlug($Model, $Model->data);

		foreach($currentSlug as $locale => $value) {
			if($value == $this->slugBackup[$locale]) continue;

			# Do not create slug log if slug_to field is empty
			if(empty($value)) {
				continue;
			}

			# Save slug change
			ClassRegistry::init('Seo.SlugLog')->saveNew([
				'type' => $Model->name == 'Page' ? 'Page' : 'Module',
				'page_id' => $Model->name == 'Page' ? $Model->id : ($Model->schema('page_id') ? $Model->data[$Model->alias]['page_id'] : null),
				'parent_page_id' => $Model->name == 'Page' ? $Model->data[$Model->alias]['parent_id'] : null,
				'model' => $Model->name,
				'foreign_key' => $Model->id,
				'from_slug' => $this->slugBackup[$locale],
				'to_slug' => $value,
				'locale' => $locale
			]);
		}

		# Insert dummy record on parent_id change in page item
		if($Model->name == 'Page' && isset($Model->data[$Model->alias]['parent_id'])) {
			if($this->parentBackup != $Model->data[$Model->alias]['parent_id']) {
				foreach($currentSlug as $locale => $value) {

					# Do not create slug log if slug_to field is empty
					if(empty($value)) {
						continue;
					}

					# Save slug change
					ClassRegistry::init('Seo.SlugLog')->saveNew([
						'type' => 'Page',
						'page_id' => $Model->id,
						'parent_page_id' => $Model->data[$Model->alias]['parent_id'],
						'model' => $Model->name,
						'foreign_key' => $Model->id,
						'from_slug' => $this->slugBackup[$locale],
						'to_slug' => $value,
						'locale' => $locale
					]);
				}
			}
		}
	}



# ~ Extract slug values from model - - - - - - - - - - - - - - - - - - - - - - #
	private function extractSlug(Model $Model, $data) {
		$slugBackup = [];

		# If multilingual
		if(count($this->languages) > 0) {
			foreach($this->languages as $locale => $language) {
				$slugBackup[$locale] = isset($data[$Model->alias]['slug__' . $locale]) ? $data[$Model->alias]['slug__' . $locale] : '';
			}
		# If singlelingual
		} else {
			$slugBackup[$this->locale] = isset($data[$Model->alias]['slug']) ? $data[$Model->alias]['slug'] : '';
		}
		return $slugBackup;
	}
}
