<?php
App::uses('CategoryBaseModel', 'Model');
class CmsEmployee extends AppModel {

	public function customIndexRestrictions() {
		# Get the Categories
		$categories = ClassRegistry::init('Page')->find('list', [
			'fields' => [ 'id', 'title' ],
			'conditions' => [
				'Page.parent_id' => 7
			]
		]);

		# Build the list
		$options = [ __('All Employees') => null ];
		foreach ($categories as $id => $category) {
			$options[$category] = [ "{$this->alias}.page_id" => $id ];
		}
		return $options;
	}

}