<?php
App::uses('RedisEngine', 'Cache/Engine');
class VectorRedisEngine extends RedisEngine {

# ~ Get all keys that match provided pattern - - - - - - - - - - - - - - - - - #
	protected function matchKeys($pattern) {
		$keys = $this->_Redis->keys($pattern);
		return $keys;
	}


# ~ Delete all keys that match pattern - - - - - - - - - - - - - - - - - - - - #
	protected function deleteMatching($pattern) {
		$keys = $this->matchKeys($pattern);
		foreach($keys as $key) {
			$this->_Redis->delete($key);
		}
	}


# ~ Overriden delete function- - - - - - - - - - - - - - - - - - - - - - - - - #
	public function delete($key) {
		if(preg_match('/\*/',$key)) {
			return $this->deleteMatching($key);
		}

		return parent::delete($key);
	}

}

