<?php

	define('ROOT', realpath('../../../../') . '/');

	$ignore = array(
		'app/Config/config.php',
		'app/webroot/assets',
		'app/webroot/thumbs',
		'app/webroot/upload',
		'app/tmp',
		'error_log',
		'VectorCMS/webroot/plugins/test/result'
	);

# ~ Configuration end, do no edit below this line  - - - - - - - - - - - - - - #
	define('START_TIME', microtime(true));

# ~ Reorganize ingores - - - - - - - - - - - - - - - - - - - - - - - - - - - - #
	foreach($ignore as $i => $file) {
		$ignore[$i] = ROOT . trim($file, '/ ');
	}

# ~ Recursivelly find files	 - - - - - - - - - - - - - - - - - - - - - - - - - #
	function scanrdir($root, $ignore = array()) {
		$list = scandir($root);

		$data = array();

		foreach($list as $file) if(!in_array($file, array('.', '..', '.git'))) {
			$file = realpath($root . $file);

			# For directories
			if(is_dir($file)) {
				$data[$file] = null;

				# Go recursively
				if(!in_array($file, $ignore)) {
					$data = array_merge($data, scanrdir($file . '/', $ignore));
				}

			# For files
			} elseif(!in_array($file, $ignore)) {
				$data[$file] = md5(file_get_contents($file));
			}
		}

		ksort($data);
		return $data;
	}

# ~ Check if file is ascii	- - - - - - - - - - - - - - - - - - - - - - - - - - #
	function is_ascii($sourcefile) {

		if (is_file($sourcefile)) {
			$content = str_replace(array("\n", "\r", "\t", "\v", "\b"), '', file_get_contents($sourcefile));
			return ctype_print($content);
		} else {
			return false;
		}
	}

