//# sourceURL=transition-sparkles.js

ShowUpTransition.sparkles = jQuery.extend({}, ShowUpTransition._defaultTransition, {

	options: {
		grid: '5x5',
		easing: 'easeOutQuad',
		random: true,

		delay: 280,
		duration: 450
	},

	setDefaults: function (content, width, height) {

		// Limit the count
		var split = this.options.grid.split('x');
		split[0] = Math.min(20, split[0]);
		split[1] = Math.min(20, split[1]);
		this.options.grid = split[0] + 'x' + split[1];

		// Set constants
		this._X = split[0];
		this._Y = split[1];
		this._Delay = this.options.delay * ShowUp.options.duration;
		this._Duration = this.options.duration * ShowUp.options.duration;
		this._Width = width / this._X;
		this._Height = height / this._Y;
		this._StartX = width;
		this._StartY = height;
		this._Easing = this.options.easing;

		// Return defaults
		return {
			w: this._Width,
			h: this._Height
		}
	},

	apply: function (content, width, height) {
		var slices = [];

		var delay = this._Delay;
		var duration = this._Duration;
		var startX = this._StartX;
		var startY = this._StartY;

		var i = -1;
		while (++i < this._X) {

			var j = -1;
			while (++j < this._Y) {

				// Random or not
				if (this.options.random) {
					delay = this._Delay * Math.random();
					duration = this._Duration * Math.random();
					startX = this._StartX * Math.random();
					startY = this._StartY * Math.random();
				}

				var slice = {
					x: i * this._Width,
					y: j * this._Height,
					animations: [
						{
							property: 'top',
							value: (j + 0.5 - this._Y / 2) * startY,
							duration: duration,
							delay: delay
						},
						{
							property: 'left',
							value: (i + 0.5 - this._X / 2) * startX,
							duration: duration,
							delay: delay
						},
						{property: 'opacity', value: 0, duration: duration * 2, delay: delay},
					]
				};

				slices.push(slice);
			}
		}

		return slices;
	}

});
