<?php
/**
 * Defines a set of specialized string functions.
 *
 * @package PhpMyAdmin-String
 */
interface PMA_StringType
{
	/**
	 * Checks if a character is an alphanumeric one
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is an alphanumeric one or not
	 */
	public function isAlnum($c);

	/**
	 * Checks if a character is an alphabetic one
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is an alphabetic one or not
	 */
	public function isAlpha($c);

	/**
	 * Checks if a character is a digit
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is a digit or not
	 */
	public function isDigit($c);

	/**
	 * Checks if a character is an upper alphabetic one
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is an upper alphabetic one or not
	 */
	public function isUpper($c);


	/**
	 * Checks if a character is a lower alphabetic one
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is a lower alphabetic one or not
	 */
	public function isLower($c);

	/**
	 * Checks if a character is a space one
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is a space one or not
	 */
	public function isSpace($c);

	/**
	 * Checks if a character is an hexadecimal digit
	 *
	 * @param string $c character to check for
	 *
	 * @return boolean whether the character is an hexadecimal digit or not
	 */
	public function isHexDigit($c);

	/**
	 * Checks if a number is in a range
	 *
	 * @param integer $num	 number to check for
	 * @param integer $lower lower bound
	 * @param integer $upper upper bound
	 *
	 * @return boolean	whether the number is in the range or not
	 */
	public function numberInRangeInclusive($num, $lower, $upper);
}
?>