;
var nxDialog;
(function ($, window, document, undefined) {
	'use strict';

	nxDialog = {

		// Current version of the nxDialog
		version: '1.0.0',

		// The list of user selected options
		options: {},

		// Default values for all options
		getDefaults: function () {
			return {

				// Configuration
				duration: 250,

				// Callbacks
				onInit: function (dialog) {
				}
			}
		},

		// Hide the dialog
		hide: function () {
			var dialog = this.getDialog().removeClass('nxDialog-ready').addClass('nxDialog-off');

			// Hide when animation is complete
			var $ = this;
			setTimeout(function () {
				dialog.removeClass('nxDialog-off').addClass('nxDialog-ready');
			}, 340);
		},

		// Get the main dialog
		getDialog: function () {
			var dialog = $('.nxDialog');
			if (!dialog.length) {
				dialog = this.buildDialog();
				$('body').append(dialog);
			}

			return dialog;
		},

		// Build the dialog
		buildDialog: function () {

			// Append the stype
			$('head').append(
				"<style rel=\"nxDialog\">" +
				".nxDialog { perspective: 600px; position: fixed; width: 100%; height: 100%; padding: 5% 0; top: 0; left: 0; display: block; z-index: 1000; }" +
				".nxDialog .nxDialog-bg { position: absolute; width: 100%; height: 100%; background:rgba(0, 0, 0, 0.43); top: 0; left: 0; transition: all 340ms ease; padding: 1em; }" +
				".nxDialog .nxDialog-content { max-height: 100%; overflow: auto; position: relative; width: 60%; margin: 0 auto; transition: all 340ms ease; z-index: 9999; top: 0; box-shadow: 0 0 15px rgba(0, 0, 0, 0.7); }" +
				".nxDialog .nxDialog-content .nxDialog-helper { display: block; }" +

				".nxDialog.nxDialog-ready { z-index: -1000; }" +
				".nxDialog.nxDialog-ready .nxDialog-bg { opacity: 0; }" +
				".nxDialog.nxDialog-ready .nxDialog-content { opacity: 0; transform-origin: 0 0; _transform: rotateX(2deg); _margin-top: 30px; }" +

				".nxDialog.nxDialog-off .nxDialog-bg { opacity: 0; }" +
				".nxDialog.nxDialog-off .nxDialog-content { opacity: 0; transform-origin: 0 0; _transform: rotateX(10deg); _margin-top: 70px; }" +

				".nxDialog-helper { display: none; max-height: 100%; }" +
				"</style>"
			);

			// Load from HTML
			var dialog = $('<div class="nxDialog nxDialog-ready">');

			// Handle the background
			dialog.data('nxDialog-content', $('<div class="nxDialog-content">'));
			dialog.data('nxDialog-bg', $('<div class="nxDialog-bg">'));
			dialog.data('nxDialog-bg').on('click', null, function () {
				nxDialog.hide();
			});

			// Append to document
			dialog
				.appendTo('body')
				.append(dialog.data('nxDialog-content'))
				.append(dialog.data('nxDialog-bg'));
		},

		// Initialize the dialog
		init: function (element, options) {
			this.options = $.extend(this.getDefaults(), options);

			// Put target inside the helper
			var id = element.attr('href').substr(1);
			var target = $('#' + id).show();

			// Create new helper
			var helperId = 'nxDialogHelper_' + id;
			var helper = $('#' + helperId);
			if (!helper.length) {
				helper = $('<div class="nxDialog-helper" id="' + helperId + '">')
					.append(target)
					.appendTo('body')
			}

			// Link helper to element
			element.data('nxDialogHelper', helper);

			// Show on click
			element.on('click', null, function (event) {
				$(this).data('nxDialogHelper').appendTo(nxDialog.getDialog().data('content'));
				nxDialog.show(element);
				return !!event.preventDefault();
			});

			// Close on ESC
			document.onkeydown = function (event) {
				event = event || window.event;
				if (event.keyCode == 27 && $('.nxDialog').is(':visible')) {
					nxDialog.hide();
				}
			};
		},

		// Show the dialog
		show: function (trigger) {

			// Make sure the dialog is active
			var dialog = this.getDialog();

			// Remove the current content
			dialog.find('.nxDialog-content .nxDialog-helper').appendTo('body');

			// Set the content of the dialog
			dialog.removeClass('nxDialog-off nxDialog-ready');
			dialog.find('.nxDialog-content').append(trigger.data('nxDialog-helper'));

			// Call the init method
			this.options.onInit(trigger.data('nxDialogHelper'), trigger);
		}
	};


	/**
	 * Define jQuery plugin.
	 * - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  */
	$.fn.nxDialog = function (options) {
		return this.each(function () {
			if (!$(this).data('plugin-nxDialog')) {

				// Initialize
				nxDialog.init($(this), options);
				$(this).data('plugin-nxDialog', options);
			}
		});
	};

	// Initailize the dialog
	nxDialog.buildDialog();
	$('.nxDialogTrigger').nxDialog();

})(jQuery, window, document);
