<?php
	signedIn() OR die;

	define('DS', DIRECTORY_SEPARATOR);
	define('ROOT', dirname(dirname(dirname(dirname(dirname(dirname(__FILE__)))))) . DS);
	define('ASSETS_ROOT',  ROOT . 'app' . DIRECTORY_SEPARATOR . 'webroot' . DIRECTORY_SEPARATOR . 'assets');

	class Config {
		static $config = array(
			'locale' => 'en-US',

			'backstep' => '/assets',

			'absolutePaths' => false,

			'maxFileSize' => 300000000,

			'allowed' => 'gif,jpg,jpeg,png,wav,mp3,wma,wmv,swf,doc,docx,xls,xlsx,ppt,pptx,odt,zip,rar,pdf,txt',

			'filters' => array(
				'image' => array('gif', 'jpeg', 'jpg', 'png'),
				'media' => array('avi', 'wmv', 'mpg', 'mpeg', 'wav', 'mp3', 'wma', 'mid'),
				'flash' => array('swf')),

			'sources' => array(
				array(
					'virtual' => '/app/webroot/plugins/innova/assetmanager/assetmanager.php',
					'base' => ASSETS_ROOT,
					'name' => '',
					'readonly' => false)),

			'icons' => array(
				'html' => 'htm',
				'jepg' => 'jpg',
				'mid' => 'sound',
				'wav' => 'sound',
				'wma' => 'sound',
				'avi' => 'video',
				'wmv' => 'video',
				'mpeg' => 'video',
				'mpg' => 'video'
			)

		);

		static function read($param) {
			return self::$config[$param];
		}

		static function icon($ext) {
			$sufix = isset(self::$config['icons'][$ext]) ? self::$config['icons'][$ext] : $ext;
			$filename = "ico_{$sufix}.gif";
			return is_file(dirname(__FILE__) . '/images/' . $filename) ? $filename : 'ico_unknown.gif';
		}

		static function allowed($sFileName) {
			return(empty(self::$config['allowed']) || in_array(strtolower(lastFromDot($sFileName)), explode(',', self::$config['allowed'])));
		}
	}

	function signedIn($name = 'pmaSignonSession') {
		session_name($name);
		session_id($_COOKIE[$name]);
		session_start();
		$allow = !empty($_SESSION['Auth']['User']['id']);
		session_write_close();

		return $allow;
	}

?>
