<?php

require_once 'AssetManager.php';
$AssetManager = new AssetManager();

if (isset($_GET['path'])) {
	echo $AssetManager->generateFiles('/' . $_GET['path'], isset($_GET['selected']) ? $_GET['selected'] : null);
	exit;
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN"
	"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<head>
	<title>Asset Manager</title>
	<meta http-equiv="content-type" content="text/html;charset=utf-8" />
	<link rel="stylesheet" href="mimetypes/style.css" />
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-1.9.1.min.js"></script>
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery.treeview.js"></script>
	<script type="text/javascript" language="javascript" src="/js/jquery/jquery-ui.min.js"></script>

	<script type="text/javascript" src="/js/swfupload/swfupload.js"></script>
	<script type="text/javascript">
		var swfu;

		window.onload = function () {
			swfu = new SWFUpload({
				upload_url: "upload.php",
				flash_url: "/js/swfupload/swfupload.swf",
				button_image_url: "upload.gif",
				button_placeholder_id: 'swfUploadButton',
				button_width: "84",
				button_height: "24",
				button_text_style: ".btn { border: 1px solid red; }",
				button_cursor: SWFUpload.CURSOR.HAND,
				//file_types : "*.jpg;*.gif",
				file_types_description: "Web Image Files",
				file_queued_handler: swfuUploadQueue,
				upload_complete_handler: swfuUpload
			});
		};

		function swfuUploadQueue() {
			swfu.setPostParams({path: $('#files').attr('rel')});
			swfu.startUpload();
		}

		function swfuUpload() {
			swfu.startUpload();
			retrieve($('#files').attr('rel'));
		}
	</script>
	<style type="text/css">
		body { margin: 0 5px; padding: 5px; font: normal 14px Arial; background: white; border: 1px solid #777; border-top: none; }
		#control { float: left; width: 48%; overflow: hidden; border-right: 1px solid #ccc; padding-right: 4px; }
		#control select { display: block; }
		#control div { height: 300px; overflow: auto; }
		#control div img { display: block; margin: auto; }
		#files { overflow: auto; height: 300px; }
		#files ul { list-style: none; margin: 0 5px; padding: 0; }
		#files ul li { margin: 1px 0; padding: 0; position: relative; border: 1px solid white; }
		#files ul li a { text-decoration: none; color: #777; display: block; padding: 3px 24px 3px 24px; font-size: 90%; overflow: hidden; }
		#files ul li:hover { color: #222; background-color: #f4f4ff; border: 1px solid #bbb; }
		#files ul li.selected { background-color: #FFF6B5; border: 1px solid #888; }
		#files ul li.selected a { color: #222; }
		#files ul li img { float: right; cursor: pointer; display: none; padding: 2px; }
		#files ul li:hover img { display: block; }
		#footer { height: 24px; margin: 4px 0 0; padding-top: 4px; border-top: 1px solid #ccc; }
		#footer div { float: right; margin-right: 14px; cursor: pointer; }
		#footer div span { display: block; color: #555; text-decoration: none; border: 1px solid white; padding: 3px 4px; }
		#footer div span:hover { color: #333; background-color: #f4f4ff; border-color: #aaa; }
	</style>
</head>
<body>
<div id="control">
	<div>
		<img id="preview" src="empty.gif" />
	</div>
</div>

<div id="files">
</div>

<div id="footer">
	<div>
		<span id="swfUploadButton">Upload files</span>
	</div>
	<div>
		<span id="swfCreateButton">Create folder</span>
	</div>
</div>

<input id="default" value="<?= $_GET['selected'] ?>" type="hidden" />
<input id="selected" value="<?= $_GET['selected'] ?>" type="hidden" />

<script type="text/javascript">
	var Editor = parent.Editor;

	$('#preview').load(function () {
		var over = $(this).parent().height() > $(this).height();
		var margin = over ? $(this).parent().height() / 2 - $(this).height() / 2 : 0;
		$(this).css('margin-top', margin);
	});

	$('#swfCreateButton').click(function () {
		var name = prompt('Enter folder name', $(this).attr('rel'));
		if (name && name.match(/<?= AssetManager::validFolderName ?>/i)) {
				alert('Supplied folder name is not valid');
		return $(this).attr('rel', name).click();
	};

	var prefix = $('#files').attr('rel').replace(/\/$/, '');
	$.get(
		'create.php?name=' + (prefix != '' ? prefix + '/' : '') + name,
		function (response) {
			if (response == 'exists') {
				alert('The folder named "' + name + '" already exists');
			}
			retrieve(false);
		}
	);
	$(this).removeAttr('rel');
	})

	function retrieve(path) {
		if (path == false) {
			path = $('#files').attr('rel');
		}
		$('#files').attr('rel', path).load('index.php?path=' + path + '&selected=' + $('#selected').val());
	}

	retrieve('<?= substr($_GET['selected'], 0, strrpos($_GET['selected'], '/')) ?>/');

	function preview(value) {
		if (value == null) {
			$('#preview').hide();
		} else {
			$('#preview').show().attr('src', Editor.static + value).load(function () {
				$(this).show();
			});
			parent.$('#<?= $_GET['field'] ?>').val(value);
			parent.$('#<?= $_GET['field'] ?>').trigger('change');
		}
	}

	function fileHover(href, force) {
		if (force || parent.$('iframe').is(':visible')) {
			//preview(null);
			switch (href.match(/\.[a-zA-Z]+$/).toString().substr(1).toLowerCase()) {
				case 'gif':
				case 'png':
				case 'jpg':
				case 'jpeg':
					preview(href);
					break;
				default:
					preview(null)
			}
		}
	}

	function perserve() {
		$("#files a")
			.hover(
				function () {
					fileHover($(this).attr("href"));
				},
				function () {
					fileHover($("#selected").val());
				})
			.click(
				function () {
					$("#files li").removeClass("selected");
					$(this).parent().addClass("selected");
					if ($(this).is('.dir a')) {
						retrieve($(this).attr('href'));
					} else {
						$('#selected').val($(this).attr('href'));
					}
					return false;
				})
			.dblclick(
				function () {
					if (!$(this).is('.dir a')) {
						parent.$('iframe').css('display', 'none');
						parent.resize();
					}
					return false;
				});

		$("#files li img.del").click(function () {
			if (confirm("Are you sure you want to permanently delete this " + ($(this).parent().is('.dir') ? "folder and its contents" : "file" ) + "?\n\nDeleted data cannot be restored from the server!")) {
				$.get(
					'delete.php?file=' + $(this).next('a').attr('href'),
					function (response) {
						retrieve(response);
					}
				);
			}
		});
	}

	function resize() {
		if (window.innerWidth > 200) {
			window.resizeTo(window.innerWidth + 8, $('body').outerHeight(true) + 80);
		}
	}

	$(document).ready(function () {
		setTimeout('resize()', 50);
		fileHover($("#selected").val(), true);
	});
</script>
</body>
</html>
