<?php
define('DS', DIRECTORY_SEPARATOR);
class AssetManager {


	var $dir = null;
	var $tree = null;
	var $files = array();

	const validFolderName = '[^a-z0-9 _/-]';

	function AssetManager() {
		$this->webroot = '/var/www/cms/public/assets/';
		$this->read();
	}

	function generateFiles($files = null, $selected = null) {
		$path = '';
		$dirs = array();
		if($files === null) {
			$files = $this->files;
		} elseif(is_string($files)) {
			$trim = trim($files, '/');
			$path = !empty($trim) ? explode('/', $trim): array();
			$files = $this->files;
			foreach($path as $dir) {
				$files = $files[$dir];
			}
			if(!empty($path)) {
				$back = rtrim(implode('/', array_slice($path, 0, -1)), '/');
				$dirs[] = "<li class=\"dir\"><a href=\"/{$back}\">[ .. ]</a></li>";
				$path = implode('/', $path) . '/';
			} else {
				$path = '';
			}
		}

		$tree = array();
		foreach($files as $filename => $file) {
			if(isset($file['basename'])) {
				$ext = isset($file['extension']) ? strtolower($file['extension']) : '';
				$url = $path . $file['basename'];
				$sel = $selected == $url ? ' selected' : '';
				$del = '<img class="del" src="icons/trash.gif" alt="X" title="Delete file" />';
				$tree[] = "<li class=\"{$ext}{$sel}\">{$del}<a href=\"{$url}\">{$file['basename']}</a></li>";
			} else {
				$del = '<img class="del" src="icons/trash.gif" alt="X" title="Delete folder" />';
				$dirs[] = "<li class=\"dir\">{$del}<a href=\"{$path}{$filename}\">[ {$filename} ]</a></li>";
			}
		}

		return '<ul>' . implode(array_merge($dirs, $tree)) . '</ul>' . '<script type="text/javascript">perserve()</script>';
	}

	function getTree($files = null) {
		if($files === null) {
			$files = $this->files;
		}

		$tree = array();
		foreach($files as $dir => $files) {
			if(!isset($files['basename'])) {
				$tree[$dir] = $this->getTree($files);
			}
		}
		return $tree;
	}

	function read($path = null, $recursive = false) {
		if(empty($path)) {
			$path = rtrim($this->webroot, '/');
		}

		if(!$dir = scandir($path)) {
			return array();
		}

		$files = array();
		foreach($dir as $file) if(isset($file{0}) && $file{0} != '.') {
			$full = $path . '/' . $file;
			$files[$file] = is_dir($full) ? $this->read($full, true) : pathinfo($full);
		}
		ksort($files);

		if(!$recursive) {
			$this->dir = $path;
			$this->files = $files;
		}

		return $files;
	}

	function upload($file, $path, $I = 0) {
		$path = trim($path, '/') . '/';
		$info = pathinfo($file['name']);
		$filename = $info['basename'];
		while(file_exists($this->webroot . $path . $filename)) {
			$i++;
			$filename = "{$info['filename']}_x{$i}.{$info['extension']}";
		}
		@move_uploaded_file($file['tmp_name'], $this->webroot . $path . $filename);
	}

	function delete($file) {
		if(is_dir($this->webroot . $file)) {
			$items = scandir($this->webroot . $file);
			foreach($items as $item) if($item != '.' && $item != '..') {
				$this->delete($file . '/' . $item);
			}
			return @rmdir($this->webroot . $file);
		} else {
			return @unlink($this->webroot . $file);
		}
	}

	function create($path) {
		$path = trim($path);
		$path = preg_replace('|' . self::validFolderName . '|i', '', $path);
		if(is_dir($this->webroot . $path)) {
			exit('exists');
		}
		@mkdir($this->webroot . $path, 0755, true);
	}

}

function debug($data) {
	ob_start();
	!empty($data) ? print_r($data) : var_dump($data);
	echo '<pre>' . ob_get_clean() . '</pre>';
}
?>
