<?php
/**
 * @var bool  $hasAndroid True if the Android push settings are set.
 * @var bool  $hasIos     True if the iOS push settings are set.
 * @var mixed $_actions   The list of available actions.
 */
?>

<style>
	<?= !$hasAndroid ? ".android { display: none; }\n" : null ?>
	<?=	 $hasAndroid || !$hasIos ? ".os { display: none; }\n" : null ?>
</style>

<div class="col-md-4 col-lg-2">
	<div class="push side-bar">
		<h4 class="side-bar-header"><?= __('Select platform') ?></h4>
		<div class="side-bar-content">
			<ul class="os-select">

				<?php if ($hasAndroid) { ?>
					<li>
						<a href="#android" rel="android" id="Android">
							<i class="fa fa-fw fa-android"></i><br />
							Android
						</a>
					</li>
				<?php } ?>

				<?php if ($hasIos) { ?>
					<li>
						<a href="#ios" rel="ios" id="iOS">
							<i class="fa fa-fw fa-apple"></i><br />
							iOS
						</a>
					</li>
				<?php } ?>

			</ul>
		</div>
	</div>
</div>

<div class="col-md-8 col-lg-10">
	<div class="push main-header with-sidebar">

		<div class="push header with-sidebar">
			<?= $this->Format->actions($_actions) ?>
		</div>

		<div class="push form with-sidebar">

			<?php if (!$hasIos && !$hasAndroid) { ?>
				<p class="info warn">
					<?= __('There are no defined configuration for any of the platforms.') ?>
					<br />
					<?= sprintf(__('Please set them in the %s.'), $this->Html->link(__('configuration'), [ C => 'configs', A => 'index', '#' => 'Push' ])) ?>
				</p>

			<?php } else { ?>

			<form method="get" class="hero-unit clearfix">
				<input type="hidden" id="Os" name="os" value="<?= $os ?>" />
				<input name="time" type="hidden" value="<?= time() ?>" />

				<p class="os ios info <?= Configure::read('Push.apple_gateway') ? 'ok' : 'warn' ?>">
					<?= Configure::read('Push.apple_gateway') ? __('Using production certificate on live server') : __('Using development certificate on sandbox server') ?>
					.
					<?= $this->Html->link(__('Change settings.'), [ P => null, C => 'configs', A => 'edit', 602 ], [ 'title' => __('Click to change the Apple push server') ]) ?>
				</p>

				<div class="input no-padding clearfix">
					<label class="os android"><?= __('Registration keys') ?></label>
					<label class="os ios"><?= __('Registration tokens') ?></label>

					<textarea name="registration_keys" class="wide" rows="4"><?= $registration_keys ?></textarea>
				</div>

				<div class="row">
					<div class="col-sm-6">
						<?php if ($hasAndroid) { ?>
							<div class="column os android">
								<div class="input no-padding clearfix">
									<label><?= __('Time to live') ?></label>
									<input name="time_to_live" value="<?= $time_to_live ?>" placeholder="defaults to 4 weeks" />
								</div>

								<div class="input no-padding clearfix">
									<label><?= __('Collapse key') ?></label>
									<input name="collapse_key" value="<?= $collapse_key ?>" placeholder="optional" />
								</div>
							</div>
						<?php } ?>

						<?php if ($hasIos) { ?>
							<div class="column os ios">
								<div class="input no-padding clearfix">
									<label><?= __('Alert') ?></label>
									<input name="alert" type="text" value="<?= $alert ?>" />
								</div>

								<div class="input no-padding clearfix">
									<label><?= __('Badge') ?></label>
									<input name="badge" value="<?= $badge ?>" placeholder="optional" />
								</div>

								<div class="input no-padding clearfix">
									<label><?= __('Sound') ?></label>
									<input name="sound" value="<?= $sound ?>" placeholder="optional" />
								</div>
							</div>
						<?php } ?>
					</div>

					<div class="col-sm-6">
						<h4>Custom fields</h4>
						<ul id="CustomFields"></ul>
					</div>
				</div>

				<div class="clearfix" style="margin-bottom: 4px"></div>

				<?= $this->Form->close(__('Send notification'), false, 'send') ?>

				<div class="clear"></div>

				<?php if (isset($error)) { ?>
					<pre class="info issue"><?= $error ?></pre>
				<?php } ?>

				<?php if (isset($response)) { ?>
					<pre class="info ok"><?= $response ? str_replace([ '<', "	" ], [ '&lt;', '' ], print_r($response, true)) : ' ~ empty response ~ ' ?></pre>
				<?php } ?>
				<?php } ?>

		</div>
	</div>
</div>

<?php if ($hasIos || $hasAndroid) { ?>
	<script src="//code.jquery.com/ui/1.10.3/jquery-ui.min.js"></script>
	<script type="text/javascript">
		var fieldCounter = 0;

		// Sortable fields
		$('.sortable').sortable({
			axis: 'y'
		});

		// AJAX submit form
		$('form').submit(function () {
			return CustomForm.submit($(this));
		});

		// Pills
		$('.os-select a').click(function () {
			$('input#Os').val($(this).attr('rel'));
			refreshPills();
		});

		// Refresh pills
		function refreshPills() {
			var os = $('input#Os').val();

			$('.os-select li').removeClass('active');
			$('.os-select a[rel=' + os + ']').closest('li').addClass('active');

			$('.os').hide();
			$('.' + os).show();
		};
		refreshPills();

		CustomForm = {

			addField: function (name, value) {
				fieldCounter++;

				var label = $('<input type="text" class="field-name">', {name: 'fields[' + fieldCounter + '][name]'}).val(name);
				var input = $('<input type="text" class="field-value">', {name: 'fields[' + fieldCounter + '][value]'}).val(value);

				// Remove field
				label.change(function () {
					if ($(this).val() == '' && $('.field-name').filter(function () {
							return $(this).val() == "";
						}).length > 1) {
						$(this).parent().remove();
					}
				});

				// Add field
				label.keyup(function () {
					if ($('.field-name').filter(function () {
							return $(this).val() == "";
						}).length == 0) {
						CustomForm.addField();
					}
				});

				var item = $('<li class="custom input" style="display:none">').append(label).append(input);
				$('#CustomFields').append(item);
				item.slideDown(50);
			},

			submit: function (form) {
				var post = form.serialize();

				$('li.custom').each(function () {
					var name = $('.field-name', $(this)).val();
					var value = $('.field-value', $(this)).val();
					if (name != '') {
						$('.field-value', $(this)).attr('name', name);
					}
				});
			}
		};

		<?php if(!empty($payload)) foreach($payload as $field => $value) { ?>
		CustomForm.addField('<?= $field ?>', '<?= $value ?>');
		<?php } ?>
		CustomForm.addField();

	</script>
<?php } ?>
