<?php
/**
 * PHP versions 4 and 5
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright     Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link          http://cakephp.org CakePHP(tm) Project
 * @package       cake
 * @subpackage    cake.cake.console.libs.templates.views
 * @since         CakePHP(tm) v 1.2.0.5234
 * @license       MIT License (http://www.opensource.org/licenses/mit-license.php)
 */

Timer::start('scaffold');
{
	$ignore = [];
	$tabNumber = 0;

	if (!isset($model)) {
		$model = ClassRegistry::init($modelClass);
	}

	# Load model plugin and store in view vars
	$modelPlugin = strtolower($model->plugin);
	$this->viewVars['model'] = $model;
	$this->viewVars['modelPlugin'] = $modelPlugin;

	# Define a list of fields to be shown on the side
	$sideFields = array_merge([ 'is_active', 'parent_id', 'category_id', 'page_id', 'approval_status', 'ordering', 'is_deleted' ], $model->sideFields);

	# Set commonly used variables
	$languages = Configure::read('Config.Languages');
	$polyglot = sizeof($languages) > 1 && !empty($model->polyglotFields);
	$datetimepicker = false;

	# Check if form has upload
	$formType = null;
	foreach ([ 'hasOne', 'hasMany' ] as $association) {
		foreach ($model->$association as $related) {
			if ($related['className'] == 'Upload') {
				$formType = 'file';
				break(2);
			}
		}
	}

	# Show SEO tab
	$showSEO = ($model->isModule && $model->hasDetails) || in_array($modelClass, [ 'Page' ]);

	echo $this->Form->create(
		$modelClass,
		[
			'class'      => 'scaffold-form tabbed',
			'type'       => $formType,
			'novalidate' => 'novalidate',
			'onsubmit'   => 'dataSubmited = true; $(".is-translated").attr("disabled", false); return true;' ]
	);

	# Prepare the tabs and other field positions
	$defaultTab = $model->getDefaultTab();
	$fields = [ $defaultTab => [] ];
	$sidefields = [];
	$otherFields = [];

	# Iterate over all fields in the model
	foreach ($model->schema(true) as $field => $params) {

		# Special statuses of the field
		$set = substr($field, -4) == '_set';
		$locked = in_array($field, $model->locked);
		$invisible = in_array($field, $model->invisible);
		if (@$this->request->data[$model->alias]['id']) {
			$invisible = in_array($field, $model->invisibleOnEdit);
		}
		$readOnly = in_array($field, $model->readOnly);

		# Some common variables
		//~ $fieldname = preg_replace('~(_id|__.*)$~', '', $field);
		$options = !empty($fieldOptions[$field]) ? $fieldOptions[$field] : [];

		# Set input field to be read only
		if ($readOnly) {
			$options['disabled'] = 'disabled';
		}

		# Skip invisible and locked fields, leave set for later
		if (!$invisible && !$locked && !$set) {

			// TODO FIX THIS SOMEHOW - should be default behaviour for checkbox with label
			if ($params['type'] == 'boolean') {
				$options['adjust'] = 'checkbox';
			} else {
				$options['adjust'] = 'filer';
			}

			// Info is this field is in side
			$options['side'] = in_array($field, $sideFields);

			$inputField = $this->Form->getField($field, $params, $options, $model);
			if ($inputField) {

				# Side frame
				$sideFieldPosition = array_search($field, $sideFields);
				if ($sideFieldPosition !== false) {
					$sidefields[$sideFieldPosition] = $inputField;

					# Main frame
				} else {

					# Pack fields into tabs
					if (!empty($model->tabs)) {
						if (!empty($model->fieldTabs[$field])) {
							$fields[$model->fieldTabs[$field]][] = $inputField;
						} else {
							$fields[$defaultTab][] = $inputField;
						}

						# No tabs
					} else {
						$fields[$defaultTab][] = $inputField;
					}
				}
			}
		}
	}

	# For hidden fields on other tabs
	if (empty($fields) && !empty($otherFields) && sizeof($otherFields) > 0) {
		$fields[$defaultTab] = $otherFields;
		$otherFields = [];
	}

	# Always begin with id
	echo $this->Form->input('id');

	# Sets
	if (!empty($model->hasSet)) {
		foreach ($model->hasSet as $association => $params)
			if (!in_array($params['field'], $model->invisible) && !in_array($params['field'], $model->locked)) {
				$properties = [
					'label'  => __(Inflector::pluralize(Inflector::humanize($association))),
					'empty'  => true,
					'class'  => 'setter',
					'value'  => 0,
					'type'   => 'select',
					'adjust' => 'filer',
					'name'   => 'data[' . $association . '][]',
					'div'    => 'input select set',
					'id'     => false
				];

				# List of selected
				$properties['after'] = '<ul class="sortable">';
				if (!empty($this->request->data[$association])) {
					foreach ($this->request->data[$association] as $item)
						if (!empty($item)) {
							$after = array_merge(
								$properties,
								[
									'div'    => false,
									'class'  => 'set-select',
									'label'  => false,
									'value'  => isset($item['id']) ? $item['id'] : $item,
									'adjust' => false,
									'after'  => '' ]
							);
							$properties['after'] .= '<li>' . $this->Form->input($association . '.' . $association, $after) . '</li>';
						}
				}
				$properties['after'] .= '</ul>';

				# Append validation errors to sets
				$validationErrors = '';
				if (isset($model->validationErrors[$association])) {
					foreach ($model->validationErrors[$association] as $valMessage) {
						$validationErrors .= '<div class="form-input-error-message">' . $valMessage . '</div>';
					}
					$properties['div'] = (string) $properties['div'] . ' form-input-error';
				}

				# Merge properties
				$properties = array_merge($properties, isset($params['params']) ? $params['params'] : []);

				# Pack fields into tabs
				$input = $this->Form->input("{$association}.{$association}", $properties);
				if (empty($model->tabs)) {
					$fields[$defaultTab][] = $input;
				} else {
					if (!empty($model->fieldTabs[$association])) {
						$fields[Inflector::camelize(Inflector::slug($model->fieldTabs[$association]))][] = $input;
					} else {
						$fields[$defaultTab][] = $input;
					}
				}
			}
	}

	# Uploads
	$activeLocale = Configure::read('Config.language');
	foreach ([ 'hasOne', 'hasMany' ] as $type) {
		foreach ($model->$type as $alias => $association) {
			if ($association['className'] == 'Upload' && !isset($model->{$type}["{$alias}__{$activeLocale}"])) {
				if ($alias == 'MetaImage')
					continue;
				if ($locale = getLocale($alias)) {
					$polyglot = true;
					$meta['locale'] = $locale;
				}

				# Add fields
				$options = [
					'details' => $association,
					'comment' => $association['comment']
				];

				# Pack fields into tabs
				if (!empty($model->tabs)) {
					if (!empty($model->fieldTabs[$alias])) {
						$fields[$model->fieldTabs[$alias]][] = $this->Form->upload($alias, $options);
					} else {
						$fields[$defaultTab][] = $this->Form->upload($alias, $options);
					}

					# No tabs
				} else {
					$fields[$defaultTab][] = $this->Form->upload($alias, $options);
				}
			}
		}
	}

	# If there are tabs and non tabbed fields, add them to other tab
	if (!empty($otherFields)) {
		$fields[$defaultTab] = array_merge($fields[$defaultTab], $otherFields);
	}

	$showSidebar = !empty($sidefields);
	echo $this->element('form/actions', [ 'showSideBar' => $showSidebar, 'showPolyglotTabs' => ($polyglot && count(Configure::read('Config.Languages')) > 1) ]);
	echo '<div class="body"><div class="row">';
	if ($showSidebar) {
		echo $this->element('form/side_form', [ 'model' => $model, 'sidefields' => $sidefields ]);
	}

	$fields = array_filter($fields);

	?>
	<div class="<?= $showSidebar ? 'col-md-9 col-lg-10' : 'col-md-12' ?>">
		<div class="cms_<?= str_replace(' ', '_', $plural) ?> form<?= $showSidebar ? ' with-sidebar' : null ?>">

			<div class="map-picker" id="GoogleMapDialog">
				<h5><?= __('Please select with left click') ?></h5>
				<div class="map-wrapper">
					<div class="map" id="GoogleMapLocationPicker">&nbsp;</div>

					<div class="row input">
						<div class="col-sm-10">
							<input id="GoogleMapSelection" class="input-block-level" type="text">
						</div>
						<div class="col-sm-2">
							<button id="GoogleMapSubmit" type="button" class="btn btn-primary pull-right"><?= __('Select') ?></button>
						</div>
					</div>

					<div class="map-loader" style="background: url(/img/form/map-loading.png)"></div>
				</div>
			</div>

			<?php if ($showSEO || $model->fieldTabs || $model->elementTabs) {
				$firstTab = true; ?>
				<ul class="nav nav-tabs">
					<?php if (empty($model->fieldTabs) && !empty($fields[$defaultTab])) {
						$tabNumber++ ?>
						<li<?= $firstTab ? ' class="active"' : null;
						$firstTab = false ?>>
							<a href="#<?= Inflector::camelize(Inflector::slug($defaultTab)) ?>Tab"><?= $defaultTab ?></a>
						</li>
					<?php } else { ?>
						<?php foreach ($fields as $tab => $fieldTabs)
							if ($model->shouldShowTab($tab, $this->request->data)) {
								$tabNumber++ ?>
								<li<?= $firstTab ? ' class="active"' : null;
								$firstTab = false ?>>
									<a href="#<?= Inflector::camelize(Inflector::slug($tab)) ?>Tab"><?= $tab ?></a>
								</li>
							<?php } ?>
					<?php } ?>

					<?php foreach ($model->elementTabs as $tabName => $tabElement)
						if ($model->shouldShowTab($tabName, $this->request->data)) {
							$tabNumber++ ?>
							<li<?= $firstTab ? ' class="active"' : null;
							$firstTab = false ?>>
								<a href="#<?= Inflector::camelize($tabName) ?>"><?= $tabName ?></a>
							</li>
						<?php } ?>

					<?php if ($showSEO) {
						$tabNumber++ ?>
						<li<?= $firstTab ? ' class="active"' : null;
						$firstTab = false ?>><a href="#SeoTab">
								<?= __('SEO') ?></a>
						</li>
					<?php } ?>
				</ul>
			<?php } ?>

			<?php $firstTab = true;
			foreach ($fields as $tab => $fieldTabs)
				if (!empty($fieldTabs)) { ?>
					<?php if (!$model->shouldShowTab($tab, $this->request->data))
						continue; ?>
					<div class="tab<?= $tabNumber ? ' multiple' : null ?>"<?= $firstTab ? null : ' style="display:none"';
					$firstTab = false ?> id="<?= Inflector::camelize(Inflector::slug($tab)) ?>Tab">
						<?= join((array) $fieldTabs) ?>
					</div>
				<?php } ?>

			<?php foreach ($model->elementTabs as $tabName => $tabElement) { ?>
				<?php if (!$model->shouldShowTab($tabName, $this->request->data))
					continue; ?>
				<div class="tab<?= $tabNumber ? ' multiple' : null ?>"<?= $firstTab ? null : ' style="display:none"';
				$firstTab = false ?> id="<?= Inflector::camelize($tabName) ?>">
					<?= $this->element($tabElement) ?>
				</div>
			<?php } ?>

			<?php if ($showSEO) { ?>
				<div class="tab<?= $tabNumber ? ' multiple' : null ?>"<?= $firstTab ? null : ' style="display:none"';
				$firstTab = false ?> id="SeoTab">
					<?= $this->element('form/meta') ?>
				</div>
			<?php } ?>

			<?php if (!empty($script)) { ?>
				<script type="text/javascript">
					<?= $script ?>
				</script>
			<?php } ?>

			<?= $this->Form->close($model->isSingleItem ? 'apply' : 'cancel') ?>
		</div>
	</div>

	<?php echo $this->Html->script([ 'jquery/jquery.iframe-transport', 'jquery/jquery.fileupload' ], false) ?>
	<?php echo $this->Html->script('scaffolds/form', [ 'inline' => false ]) ?>
	<script type="text/javascript">
		$(document).ready(function () {
			var scaffoldForm = new ScaffoldForm({
				'modelClass': '<?= $modelClass ?>',
				'initializeMultipleEdit': <?= !empty($this->request->params['multiple']) ? 'true' : 'false' ?>,
				'initializeSet': <?= !empty($model->hasSet) ? 'true' : 'false' ?>,
				'translations': {
					'ajax_save_error': '<?= __('Warning:\nYour changes have not been saved.') ?>',
					'ajax_success_message': '<?= __('The record has been successfully saved.') ?>',
					'expand': '<?= __('Expand') ?>',
					'colapse': '<?= __('Colapse') ?>',
					'remove': '<?= __('Remove') ?>'
				}
			});
		});
	</script>
<?php }
Timer::end('scaffold') ?>
