<?php
/**
 *
 * PHP versions 4 and 5
 *
 * CakePHP(tm) : Rapid Development Framework (http://cakephp.org)
 * Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 *
 * Licensed under The MIT License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright	  Copyright 2005-2009, Cake Software Foundation, Inc. (http://cakefoundation.org)
 * @link		  http://cakephp.org CakePHP(tm) Project
 * @package		  cake
 * @subpackage	  cake.cake.console.libs.templates.views
 * @since		  CakePHP(tm) v 1.2.0.5234
 * @license		  MIT License (http://www.opensource.org/licenses/mit-license.php)
 */
	Timer::start('scaffold');

	$model = ClassRegistry::init($modelClass);
	$schema = $model->schema(true);
	foreach($schema as $field => $params) if(substr($params['type'], 0, 4) == 'enum') {
		$schema[$field]['type'] = 'enum';
	}

	# Set default ordering visible
	if(!empty($model->order) && empty($this->request->params['paging'][$model->alias]['options']['order'])) {
		$this->request->params['paging'][$model->alias]['options']['order'] = $model->order;
	}

	$classMapping = array(
		'float' => 'int',
		'integer' => 'int',
		'string' => 'char',
		'enum' => 'char',
		'text' => 'text',
		'tinytext' => 'text',
		'boolean' => 'bool',
		'datetime' => 'time',
		'date' => 'date',
		'association' => 'img'
	);

	Timer::start('field prepration');

		$showFields = array();
		if(isset($administrator['Administrator']['customization'][$modelClass])) {
			foreach($administrator['Administrator']['customization'][$modelClass] as $field => $params) {
				if(!empty($params['show']) && !in_array($field, $model->invisible) && ($model->schema($field) || isset($model->hasOne[$field]))) {
					$column['ordering'] = isset($params['ordering']) ? $params['ordering'] : PHP_INT_MAX;
					$column['field'] = $field;
					$column['label'] = Inflector::humanize($field);
					$column['type'] = $model->schema($field) ? reset(explode('(', $model->_schema[$field]['type'])) : 'association';
					switch(true) {
						case $column['field'] == $model->displayField:
							$column['class'] = 'title';
							break;
						case substr($column['field'], -3) == '_id':
							$column['class'] = 'char';
							break;
						default: $column['class'] = isset($classMapping[$column['type']]) ? $classMapping[$column['type']] : null;
					}
					$showFields[] = $column;
				}
			}
		}

		if(empty($showFields)) {
			$showFields[] = array(
				'ordering' => 0,
				'field' => $model->displayField,
				'label' => Inflector::humanize($model->displayField),
				'type' => 'string',
				'class' => 'title'
			);
			$showFields[] = array(
				'ordering' => 1,
				'field' => 'controller_action',
				'label' => __('Action'),
				'type' => 'string',
				'class' => 'char'
			);
			$showFields[] = array(
				'ordering' => 2,
				'field' => 'status',
				'label' => __('Status'),
				'type' => 'string',
				'class' => 'char'
			);
			$showFields[] = array(
				'ordering' => 3,
				'field' => 'created',
				'label' => __('Created'),
				'type' => 'date',
				'class' => 'date'
			);
		}

		$showFields = Set::sort($showFields, '{n}.ordering', ASC);

	Timer::end('field prepration');
?>

<?= $this->Html->script('dragtable', false, array('inline' => false)) ?>

<?= $this->element('index/side_bar') ?>

<div class="header">
	<?php
		Timer::start('Buttons');

			echo $this->Format->actions(array_merge(
				array(

					# Add new
					$model->isAddable()
						? array('plus', __('Add new'), array(C => $controller, A => 'add'), array('class' => 'btn btn-success'))
						: array(),

					# Edit
					$model->isModule && $model->hasDetails
						? array('picture', __('Edit template'), array(C => 'pages', A => 'module', $modelClass))
						: array(),

					# Categories
					$model->schema('category_id')
						? array('folder-open', __('View categories'), array(C => $controller, A => 'categories'))
						: array(),

					# Comments
					$model->isModule && $model->hasComments
						? array('align-left', __('View comments'), array(C => $controller, A => 'comments'))
						: array(),

					# Customize view
					array('columns', __('Customize view'), '#CustomizeTableModal', array('class' => 'btn btn-default', 'role' => 'button',	'data-toggle' => 'modal')),

					# Treesort
					!empty($treeview)
						? array('resize-vertical', __('Sort'), '#SortTreeModal', array('class' => 'btn btn-default', 'role' => 'button',  'data-toggle' => 'modal'))
						: array()),

				# Additional actions from controller
				$_actions,

				# Filter
				array($this->Format->filter())
			));


			# For tree view
			if(!empty($treeview)) {
				echo $this->element('index/sort_tree');
			}

			# Customize view
			echo $this->element('index/customize_table');

		Timer::end('Buttons');

		# Filter
		Timer::start('Filter');

			$filter = array('_keyword');
			$keywords = false;
			$ignoreFilter = array('id', 'ordering', 'modified', 'modified_by', 'created', 'created_by');
			foreach($schema as $field => $params) if(!in_array($params['type'], array('string', 'text')) && !in_array($field, array_merge($ignoreFilter, $model->invisible))) {
				$filter[] = $field;
			}
			echo $this->Format->filter($filter);

		Timer::end('Filter');
   ?>
</div>

<div class="<?= $plural ?> index">
	<?php if(!empty($records)) { ?>

		<div class="table-options clearfix">
			<?= $this->element('index/paginator') ?>
		</div>

		<table cellpadding="0" cellspacing="0" class="draggable" id="<?= $model->alias ?>Index">
			<tr>
				<th class="box">&nbsp;</th>
				<?php foreach($showFields as $field) { ?>
					<th id="th-<?= $field['field'] ?>" class="<?= $field['class'] ?>"><?= !empty($this->request->params['all']) ? str_replace('/index/all/', '/all/', $this->Paginator->sort($field['field'])) : $this->Paginator->sort($field['field']) ?></th>
				<?php } ?>
				<th class="actions"><?= __('Actions') ?></th>
			</tr>
			<?php Timer::start('output'); { ?>
				<?php foreach($records as $i => $record) { ?>
					<?php

						# For tree view
						if(!empty($treeview)) {
							$class = !empty($record[$model->alias]['parent_id']) ? 'child-of-row-' . $record[$model->alias]['parent_id'] : '';
						} else {
							$class = $i % 2 ? 'even' : 'odd';
							$clsss= '';
						}
					?>
					<tr id="row-<?= $record[$model->alias][$model->primaryKey] ?>" class="<?= $class ?>">
						<td class="box"><input type="checkbox" id="PageBox-<?= $record[$model->alias][$model->primaryKey] ?>" value="<?= $record[$model->alias][$model->primaryKey] ?>" name="data[Page][box-<?= $record[$modelClass][$model->primaryKey] ?>]">
						<?php
							foreach($showFields as $i => $field) {
								$class = '';
								$value = !empty($record[$modelClass][$field['field']]) ? strip_tags($record[$modelClass][$field['field']]) : '';
								switch($field['field']) {
									default:

										# Display field
										if($field['class'] == 'title') {
											if($model->isEditable($record[$modelClass][$model->primaryKey])) {
												$value = $this->Html->link($record[$modelClass][$field['field']], array(C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey]));
											} else {
												$value = $this->Html->link($record[$modelClass][$field['field']], array(C => $controller, A => 'view', $record[$modelClass][$model->primaryKey]));
											}

										# Special fields
										} elseif($field['field'] == 'url') {
											$value = $this->Html->link(preg_replace('~^[^:]*://~', '', $value), $value, array('target' => '_blank'));

										# Associative fields
										} elseif(($id = substr($field['field'], -3) == '_id') || (($var = Inflector::variable(Inflector::pluralize($field['field']))) && isset($$var))) {
											if($id) {
												$var = Inflector::variable(Inflector::pluralize(substr($field['field'], 0, -3)));
											}
											$var = $$var;
											$value = isset($var[$value]) ? $var[$value] : null;

										# Uploads
										} elseif(isset($record[$field['field']])) {
											if(!empty($record[$field['field']]['filename'])) {
												$value = $this->Format->image($record[$field['field']], 75, 55, $field['field']);
											} else {
												$value = $this->Html->tag('span', '-', array('style' => 'color:#888'));
											}

										# Other fields
										} else {
											$class = $classMapping[$schema[$field['field']]['type']];
											switch($model->_schema[$field['field']]['type']) {
												case 'boolean':
													$value = $this->Format->toggle($controller, $record[$modelClass], $field['field']);
													break;
												case 'date':
													$value = $this->Format->time($value);
													break;
												case 'datetime':
													$value = $this->Format->time($value, true);
													break;
											}
										}
								}
								$class = !empty($field['class']) ? ' class="' . $field['class'] . '"' : '';

								echo "<td{$class}>{$value}</td>\n";
							}
						?>
						<td class="actions">
							<?php
								Timer::startLoop('Actions'); {
									echo $this->Format->actions(array(

										# View
										$model->Alias == 'Page'
											? array('eye', '', $this->Format->pageLink($record[$modelClass][$model->primaryKey]), array('class' => 'btn btn-default btn-sm btn-icon-only', 'target' => '_blank'))
											: array('eye', '', array(C => $controller, A => 'view', $record[$modelClass][$model->primaryKey]), array('class' => 'btn btn-default btn-sm btn-icon-only')),

										# Edit
										$model->isEditable($record[$modelClass][$model->primaryKey])
											? array('pencil', '', array(C => $controller, A => 'edit', $record[$modelClass][$model->primaryKey]), array('class' => 'btn btn-default btn-sm btn-icon-only'))
											: array(),

										# Delete
										$model->isDeletable($record[$modelClass][$model->primaryKey])
											? array('trash-o', '', array(C => $controller, A => 'delete', $record[$modelClass][$model->primaryKey]), array('class' => 'btn btn-danger btn-sm btn-icon-only', 'confirm' => __('Are you sure you want to delete') . ":\n" . $record[$modelClass][$model->displayField] . ' ?'))
											: array()
									));
								} Timer::endLoop('Actions');
							?>
						</td>
					</tr>
				<?php } ?>
			<?php } Timer::end('output') ?>
		</table>

		<div class="table-options clearfix">
			<?= $this->element('index/paginator', array('bottom' => true)) ?>
		</div>

		<script type="text/javascript">
			$('#<?= $model->alias ?>Index .bool a[class^=switch_]').click(function() {
				$(this).children('img').attr('src', $(this).children('img').attr('src').replace(/[0_1].png$/, 'loader_small.gif'));
				$.get(
					$(this).attr('href'),
					function(response) {
						if(response == 'Error!') return;
						if(typeof(response) == 'string') {
							eval('response = ' + response + ';');
						}
						if(response.single && response.value != '0') {
							var imgs = $('#<?= $model->alias ?>Index td a[class^=switch_' + response.field + '_]:not(#<?= $model->alias ?>Index .bool a.switch_' + response.field + '_' + response.id + ') > img');
							imgs.attr('src', imgs.attr('src').replace(/[0_1].png$/, '0.png'));
						}
						var img = $('#<?= $model->alias ?>Index .bool a.switch_' + response.field + '_' + response.id + ' > img');
						img.attr('src', img.attr('src').replace('loader_small.gif', response.value + '.png'));
					}
				);
				return false;
			});
			<?php if($treeview) { ?>
				$(function() {
					$("#<?= $model->alias ?>Index").treetable({
						treeColumn: 1,
						expandable: true,
						initialState: 'expanded'
					});
				});
			<?php } ?>
		</script>

	<?php } else { ?>
		<div class="empty well">
			<?php if(empty($this->request->params['filter'])) { ?>
				<?= __('There are no records for this module in the database.') ?>
				<?php if(in_array($this->request->params[C], Set::extract('/Module/use_table', Stash::read('modules')))) { ?>
					<br /><br />
					<?= $this->Html->link(__('Click here to populate with random records.'), array(C => $controller, A => 'populate', 7))  ?>
				<?php } ?>
			<?php } else { ?>
				<?= __('No records have been found, please refine your search.') ?>
			<?php } ?>
		</div>
	<?php } ?>

</div>

<?php Timer::end('scaffold') ?>
