<?php

/**
 * @var \Exception $error The error to show.
 */

use Intellex\Debugger\Debugger;
error_reporting(0);

// Define the steps
$steps = $error->getTrace();
if (method_exists($error, 'getFile')) {
	array_unshift($steps, [
		'file' => $error->getFile(),
		'line' => $error->getLine()
	]);
}

// Get the true origin
$origin = null;
if (preg_match('~ in (?<file>.+?)::(?<line>\d+\b)~ Uui', $error->getMessage(), $match)) {
	$origin['file'] = $match['file'];
	$origin['line'] = $match['line'];
}

// Add to steps
$history = [];
foreach ($steps as $step) {
	$step['snippet'] = [];

	# Open file
	if (key_exists('file', $step)) {
		$file = explode("\n", file_get_contents($step['file']));
		$from = max(0, $step['line'] - 4);
		$to = min(sizeof($file), $step['line'] + 5);
		$snippet = array_slice($file, $from, $to - $from);

		$step['snippet'] = [];
		foreach ($snippet as $i => $line) {
			$step['snippet'][$from + $i + 1] = str_replace("\t", '    ', $line);
		}
	}

	$history[] = $step;
}

// Get the default section to open
$open = 1;
foreach ($history as $i => $step) {
	if (key_exists('file', $step) && key_exists('line', $step) && (empty($origin) || ($origin['file'] == $step['file'] && $origin['line'] == $step['line']))) {
		$open = $i;
		break;
	}
}

(headers_sent() || Debugger::isCli()) or header($_SERVER['SERVER_PROTOCOL'] . ' ' . 500 . ' Internal Server Error', true, 500);

?>
<!DOCTYPE html>
<html>
<head>
	<?= $this->Html->charset() ?>

	<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, maximum-scale=1">
	<title>VectorCMS error</title>

	<?= $this->element('layout/head') ?>

</head>
<body class="exception">
<div class="wrapper" style="padding-bottom: 30px;">
	<img class="bottom-image" src="/theme/decoration.png" />

	<?= $this->Session->flash() ?>

	<div class="row">
		<div class="col-md-10 col-md-offset-1 col-lg-10 col-lg-offset-1 col-xl-8 col-xl-offset-2">

			<div class="options">
				<?php

				# Option: Show error log
				$options[] = $this->Html->link(
					'<i class="fa fa-list"></i>' .
					__('Show error log'),
					BACK_BASE_URL . Router::url([ P => null, C => 'logs', A => 'system' ]),
					[ 'class' => 'btn btn-primary', 'target' => '_blank' ]);

				# Option: Clear cache
				$options[] = $this->Html->link(
					'<i class="fa fa-ban"></i>' .
					__('Clear cache'),
					BACK_BASE_URL . Router::url([ P => null, C => 'tools', A => 'clear' ]),
					[ 'class' => 'btn btn-default' ]);

				# Print options
				echo implode("\n", $options);
				?>
			</div>

		</div>
	</div>

	<div class="row">
		<div class="col-md-10 col-md-offset-1 col-lg-10 col-lg-offset-1 col-xl-8 col-xl-offset-2">

			<div class="error-box clearfix">
				<div id="content" class="log-details">
					<i class="fa fa-fw fa-exclamation-circle error"></i>

					<br />
					<h2><?= $error->getMessage() ?></h2>
					<br />

					<ul class="trace">
						<?php foreach ($history as $i => $step) { ?>
							<li class="step">
								<a class="file" data-step="<?= $i ?>" onclick="<?= key_exists('file', $step) ? 'toggle(this); ' : null ?>return false;" href="#step-<?= $i ?>">

									<?php if (key_exists('class', $step) || key_exists('type', $step) || key_exists('function', $step)) { ?>
										<?php if (key_exists('class', $step)) { ?>
											<span class="class"><?= $step['class'] ?></span>
										<?php } ?>

										<?php if (key_exists('type', $step)) { ?>
											<span class="type"><?= $step['type'] !== '->' ? $step['type'] : '➝' ?></span>
										<?php } ?>

										<?php if (key_exists('function', $step)) { ?>
											<span class="function"><?= $step['function'] ?></span>
											(
											<?php
											if (key_exists('args', $step)) {
												foreach ($step['args'] as $index => $arg) {
													echo $index ? ', ' : null;
													?>
													<span class="arg"><?= \Intellex\Debugger\Debugger::getReadableValue($arg, 32) ?></span>
													<?php
												}
											}
											?>
											)
										<?php } ?>

										<br />
									<?php } ?>

									<span class="path"><?= key_exists('file', $step) ? $step['file'] . ' : ' . $step['line'] : null ?></span>
								</a>

								<div class="code<?= $open === $i ? ' opened' : null ?>" data-step="<?= $i ?>">
									<?= \Intellex\Debugger\Debugger::formatCode(file_get_contents($step['file']), $step['line'], $step['line'] - 8, $step['line'] + 8) ?>
								</div>
							</li>
						<?php } ?>
					</ul>

				</div>
			</div>

		</div>
	</div>

	<br /><br />

	<img class="top-leaves" src="/img/leaves_top.png" />
	<div class="clear"></div>

	<?= $this->element('layout/footer') ?>
</div>

<script type="text/javascript">
	function toggle(item) {
		item.nextSibling.nextSibling.classList.toggle('opened');
	}

	function nav(item) {
		closeSiblings(item, 'active');

		var section = document.getElementById(item.href.replace(/^.+#/, ''));
		closeSiblings(section, 'show');
		return false;
	}

	function closeSiblings(item, className) {
		for (var i in item.parentNode.childNodes) {
			if (item.parentNode.childNodes.hasOwnProperty(i)) {
				if (item.parentNode.childNodes[i].nodeName && item.parentNode.childNodes[i].nodeName !== '#text') {
					item.parentNode.childNodes[i].classList.remove(className);
				}
			}
		}
		item.classList.add(className);
	}
</script>

</body>
</html>
