<div class="header">
	<?=
	$this->Format->actions([
		[ 'save', __('Save'), 'javascript: void(0)', [ 'class' => 'btn btn-primary', 'onclick' => 'dataSubmited = true; $(\'#DictionaryForm\').submit();' ] ],
		[ 'globe', __('Show languages'), [ C => $controller, A => 'index' ] ]
	])
	?>

	<?php
	$this->Form->create('Filter');
	$this->Form->end();
	?>
	<form id="FilterForm" accept-charset="utf-8" class="visible" method="POST">
		<div class="input text">
			<label for="Filter-keyword"><?= __('Keyword') ?></label>
			<div class="input-field">
				<input type="text" id="Filter-keyword" name="just-for-post">
			</div>
		</div>

		<div class="input select">
			<label for="Filter-group"><?= __('Group') ?></label>
			<div class="input-field">
				<select id="Filter-group">
					<option value="<?= DICTIONARY_GROUP_FRONT ?>"><?= __('Frontend') ?></option>
					<option value="<?= DICTIONARY_GROUP_BACK ?>"><?= __('Backend') ?></option>
				</select>
			</div>
		</div>

		<div class="clear"></div>

		<div class="input select"<?= sizeof(Configure::read('Config.Languages')) < 2 ? ' style="display:none"' : '' ?>>
			<label for="Filter-locale"><?= __('Translating to') ?></label>
			<div class="input-field">
				<select id="Filter-locale">
					<?php foreach (Configure::read('Config.Languages') as $locale => $language) { ?>
						<option value="<?= $locale ?>"><?= $language['Language']['title'] ?></option>
					<?php } ?>
				</select>
			</div>
		</div>

		<div class="input select">
			<label for="Filter-translated"><?= __('Is Translated') ?></label>
			<div class="input-field">
				<select id="Filter-translated">
					<option value=""></option>
					<option value="no"><?= __('No') ?></option>
					<option value="yes"><?= __('Yes') ?></option>
				</select>
			</div>
		</div>
	</form>
	<div class="clear"></div>
</div>

<?= $this->Form->create('Dictionary', [ 'url' => [ C => 'languages', A => 'dictionary' ], 'id' => 'DictionaryForm' ]) ?>
<input name="just-for-post" value="POST" style="display:none" />
</form>
<div id="Dictionary" class="index">
	<?php if (!empty($dictionary)) { ?>
		<table cellpadding="0" cellspacing="0">
			<?php
			foreach ($dictionary as $entry) {
				$key = $this->Html->tag('td', $entry['Dictionary']['key'], [ 'width' => '35%', 'class' => 'key' ]);
				$value = $this->Html->tag('td', $entry['Dictionary']['value'], [ 'width' => '*', 'class' => 'value', 'rel' => $entry['Dictionary']['id'] ]);

				echo $this->Html->tag(
					'tr',
					$key . $value,
					[
						'locale' => $entry['Dictionary']['locale'],
						'domain' => $entry['Dictionary']['domain'],
						'group'  => $entry['Dictionary']['group'],
						'rel'    => $entry['Dictionary']['key'] . '|#|#|' . $entry['Dictionary']['value'] ]
				);
			}
			?>
		</table>
		<div class="empty well">
			<?= __('No word matches your filter criteria') ?>
		</div>
		<script type="text/javascript">
			var liveHover = true;
			var dataSubmited = false;
			var dataHasChanged = false;
			var saveInProgress = false;

			/* Live filter */
			function liveFilter() {
				var keyword = '';
				if ($('#Filter-keyword').val() != '') {
					keyword = '[rel*="' + $('#Filter-keyword').val() + '"]';
				}

				var translated = '';
				if ($('#Filter-translated').val() != '') {
					translated = $('#Filter-translated').val() == 'yes' ? ':not([rel$="|#|#|"])' : '[rel$="|#|#|"]';
				}

				var group = '';
				if ($('#Filter-group').val() != '') {
					group = '[group="' + $('#Filter-group').val() + '"]';
				}

				$('#Dictionary table').show();
				$('#Dictionary table tr').removeClass('alt').hide();
				$('#Dictionary table tr[locale=' + $('#Filter-locale').val() + ']' + keyword + group + translated).show();
				$('#Dictionary table tr:visible:odd').addClass('alt');

				var empty = $('#Dictionary table tr:visible').length == 0;
				$('.empty').toggle(empty);
				$('#Dictionary table').toggle(!empty);
			}

			$('#Filter-group').change(function () {
				liveFilter();
			});
			$('#Filter-locale').change(function () {
				liveFilter();
			});
			$('#Filter-keyword').keyup(function () {
				liveFilter();
			});
			$('#Filter-translated').change(function () {
				liveFilter();
			});
			liveFilter();

			/* Hover for rows */
			$('#Dictionary table tr').hover(
				function () {
					if (liveHover) $(this).addClass('over')
				},
				function () {
					if (liveHover) $(this).removeClass('over')
				}
			);

			/* Click to edit */
			$('#Dictionary table tr').click(function () {
				liveHover = false;
				var tr = $(this).addClass('over').addClass('edit');
				var td = $(this).children('td.value');
				var input = $('<input>')
					.val(td.text())
					.css({
						top: td.offset().top - 3,
						left: td.offset().left,
						width: td.outerWidth() - 1,
						height: td.outerHeight() + 1,
						background: 'white'
					})
					.change(function () {
						dataHasChanged = true;
					})
					.keydown(function (key) {
						switch (key.keyCode) {
							case 40:
							case 13:
								if (tr.nextAll(':visible:first').length > 0) {
									$(this).blur();
									tr.nextAll(':visible:first').click();
								}
								break;
							case 38:
								if (tr.prevAll(':visible:first').length > 0) {
									$(this).blur();
									tr.prevAll(':visible:first').click();
								}
								break;
						}
					})
					.keyup(function (key) {
						switch (key.keyCode) {
							case 27:
								$(this).attr('cancel', 1);
							case 13:
								$(this).blur();
						}
					})
					.blur(function (event) {
						liveHover = true;
						tr.removeClass('over').removeClass('edit');

						var value = $(this).val();

						if (typeof $(this).attr('cancel') != 'undefined' || value.trim() == td.text().trim()) {
							$(this).remove();
							return;
						}

						// Create icon for this item
						var icon = $('<i>')
							.addClass('fa fa-fw fa-refresh marker')
							.css({
								'position': 'absolute',
								'top': td.offset().top,
								'left': td.offset().left - 40,
								'font-size': '2em'
							})
							.html('&nbsp;');

						// Append default icon
						tr.find('.key').append(icon);

						saveInProgress = true;

						// Ajax update
						$.ajax({
							url: '/languages/save_term',
							type: 'post',
							data: {
								'key': tr.attr('rel').replace(/\|#\|#\|.*$/m, ''),
								'domain': tr.attr('domain'),
								'locale': tr.attr('locale'),
								'value': value
							},
							dataType: 'json',
							success: function (data) {
								if (data.success) {

									// Show ok marker
									tr.find('.marker')
										.removeClass('fa-refresh')
										.addClass('fa-check')
										.css('color', 'green');

									// Hide marker after 2s
									setTimeout(function () {
										tr.find('.marker').fadeOut(function () {
											$(this).remove();
										});
									}, 2000);

									return;
								}

								// Bad marker
								tr.find('.marker')
									.removeClass('fa-refresh')
									.addClass('fa-remove')
									.css('color', 'red')
									.click(function () {
										alert(data.message);
									});
							},
							complete: function (xhr, status) {
								saveInProgress = false;
							}

						});

						td.text(value);
						tr.attr('rel', tr.attr('rel').replace(/\|#\|#\|.*$/m, '|#|#|') + $(this).val());
						$(this).remove();
					});

				// Pull value from database, just in case someone else is working on dictionary
				$.ajax({
					url: '/languages/get_term',
					type: 'post',
					data: {
						'key': tr.attr('rel').replace(/\|#\|#\|.*$/m, ''),
						'domain': tr.attr('domain'),
						'locale': tr.attr('locale'),
					},
					dataType: 'json',
					success: function (data) {
						input.val(data.value);
						$('#Dictionary').append(input);
						$(input).select().focus();
					}
				});
			});
		</script>
	<?php } else { ?>
		<div class="empty well"><?= __('Dictionary is empty') ?></div>
	<?php } ?>
</div>
